/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.type.base;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kerby.asn1.Asn1FieldInfo;
import org.apache.kerby.asn1.EnumType;
import org.apache.kerby.asn1.ExplicitField;
import org.apache.kerby.asn1.type.Asn1Integer;
import org.apache.kerby.asn1.type.Asn1Type;
import org.apache.kerby.kerberos.kerb.type.KerberosStrings;
import org.apache.kerby.kerberos.kerb.type.KrbSequenceType;
import org.apache.kerby.kerberos.kerb.type.base.NameType;

public class PrincipalName
extends KrbSequenceType {
    private static Asn1FieldInfo[] fieldInfos = new Asn1FieldInfo[]{new ExplicitField((EnumType)PrincipalNameField.NAME_TYPE, Asn1Integer.class), new ExplicitField((EnumType)PrincipalNameField.NAME_STRING, KerberosStrings.class)};
    private String realm;

    public PrincipalName() {
        super(fieldInfos);
    }

    public PrincipalName(String nameString) {
        super(fieldInfos);
        this.setNameType(NameType.NT_PRINCIPAL);
        this.fromNameString(nameString);
    }

    public PrincipalName(String nameString, NameType type) {
        super(fieldInfos);
        this.fromNameString(nameString);
        this.setNameType(type);
    }

    public PrincipalName(List<String> nameStrings, NameType nameType) {
        super(fieldInfos);
        this.setNameStrings(nameStrings);
        this.setNameType(nameType);
    }

    public static String extractRealm(String principal) {
        int pos = principal.indexOf(64);
        if (pos > 0) {
            return principal.substring(pos + 1);
        }
        throw new IllegalArgumentException("Not a valid principal, missing realm name");
    }

    public static String extractName(String principal) {
        int pos = principal.indexOf(64);
        if (pos < 0) {
            return principal;
        }
        return principal.substring(0, pos);
    }

    public static String makeSalt(PrincipalName principalName) {
        StringBuilder salt = new StringBuilder();
        if (principalName.getRealm() != null) {
            salt.append(principalName.getRealm());
        }
        List<String> nameStrings = principalName.getNameStrings();
        for (String ns : nameStrings) {
            salt.append(ns);
        }
        return salt.toString();
    }

    public NameType getNameType() {
        Integer value = this.getFieldAsInteger(PrincipalNameField.NAME_TYPE);
        return NameType.fromValue(value);
    }

    public void setNameType(NameType nameType) {
        this.setFieldAsInt(PrincipalNameField.NAME_TYPE, nameType.getValue());
    }

    public List<String> getNameStrings() {
        KerberosStrings krbStrings = (KerberosStrings)this.getFieldAs(PrincipalNameField.NAME_STRING, KerberosStrings.class);
        if (krbStrings != null) {
            return krbStrings.getAsStrings();
        }
        return Collections.emptyList();
    }

    public void setNameStrings(List<String> nameStrings) {
        this.setFieldAs(PrincipalNameField.NAME_STRING, (Asn1Type)new KerberosStrings(nameStrings));
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getName() {
        return this.makeSingleName();
    }

    private String makeSingleName() {
        List<String> names = this.getNameStrings();
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (String name : names) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append('/');
            }
            sb.append(name);
        }
        if (this.realm != null && !this.realm.isEmpty()) {
            sb.append('@');
            sb.append(this.realm);
        }
        return sb.toString();
    }

    private void fromNameString(String nameString) {
        String nameParts;
        if (nameString == null) {
            return;
        }
        int realmPos = nameString.indexOf(64);
        if (realmPos != -1) {
            nameParts = nameString.substring(0, realmPos);
            this.realm = nameString.substring(realmPos + 1);
        } else {
            nameParts = nameString;
        }
        String[] parts = nameParts.split("\\/");
        List<String> nameStrings = Arrays.asList(parts);
        this.setNameStrings(nameStrings);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PrincipalName)) {
            return false;
        }
        PrincipalName otherPrincipal = (PrincipalName)((Object)other);
        return this.getNameType() == ((PrincipalName)((Object)other)).getNameType() && this.getName().equals(otherPrincipal.getName());
    }

    public String toString() {
        return this.getName();
    }

    protected static enum PrincipalNameField implements EnumType
    {
        NAME_TYPE,
        NAME_STRING;


        public int getValue() {
            return this.ordinal();
        }

        public String getName() {
            return this.name();
        }
    }
}

