/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.featurecollection.FeatureCollectionType;
import thredds.filesystem.MFileOS;
import thredds.inventory.CollectionAbstract;
import thredds.inventory.CollectionGeneral;
import thredds.inventory.CollectionSingleFile;
import thredds.inventory.CollectionSingleIndexFile;
import thredds.inventory.CollectionSpecParser;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import thredds.inventory.filter.StreamFilter;
import thredds.inventory.partition.DirectoryCollection;
import thredds.inventory.partition.DirectoryPartition;
import thredds.inventory.partition.FilePartition;
import thredds.inventory.partition.IndexReader;
import thredds.inventory.partition.PartitionManager;
import thredds.inventory.partition.PartitionManagerFromIndexDirectory;
import ucar.nc2.constants.CDM;
import ucar.nc2.grib.collection.GcMFile;
import ucar.nc2.grib.collection.Grib1CollectionBuilder;
import ucar.nc2.grib.collection.Grib1CollectionBuilderFromIndex;
import ucar.nc2.grib.collection.Grib1PartitionBuilder;
import ucar.nc2.grib.collection.Grib1PartitionBuilderFromIndex;
import ucar.nc2.grib.collection.Grib2CollectionBuilder;
import ucar.nc2.grib.collection.Grib2CollectionBuilderFromIndex;
import ucar.nc2.grib.collection.Grib2PartitionBuilder;
import ucar.nc2.grib.collection.Grib2PartitionBuilderFromIndex;
import ucar.nc2.grib.collection.GribCollection;
import ucar.nc2.grib.collection.GribCollectionBuilder;
import ucar.nc2.grib.collection.GribCollectionProto;
import ucar.nc2.grib.collection.GribPartitionBuilder;
import ucar.nc2.grib.grib1.Grib1RecordScanner;
import ucar.nc2.grib.grib2.Grib2RecordScanner;
import ucar.nc2.stream.NcStream;
import ucar.unidata.io.RandomAccessFile;

public class GribCdmIndex
implements IndexReader {
    private static final boolean debug = false;
    private byte[] magic;
    private int version;
    private GribCollectionProto.GribCollection gribCollectionIndex;
    private final Logger logger;

    public static GribCollectionType getType(RandomAccessFile raf) throws IOException {
        String magic;
        raf.seek(0L);
        byte[] b = new byte["Grib2Collectio2Index".getBytes(CDM.utf8Charset).length];
        raf.readFully(b);
        switch (magic = new String(b)) {
            case "Grib2Collectio2Index": {
                return GribCollectionType.GRIB2;
            }
            case "Grib1Collectio2Index": {
                return GribCollectionType.GRIB1;
            }
            case "Grib2Partition2Index": {
                return GribCollectionType.Partition2;
            }
            case "Grib1Partition2Index": {
                return GribCollectionType.Partition1;
            }
        }
        return GribCollectionType.none;
    }

    public static GribCollection openCdmIndex(String indexFilename, FeatureCollectionConfig config, boolean dataOnly, Logger logger) {
        return GribCdmIndex.openCdmIndex(indexFilename, config, dataOnly, true, logger);
    }

    public static GribCollection openCdmIndex(String indexFilename, FeatureCollectionConfig config, boolean dataOnly, boolean useCache, Logger logger) {
        GribCollection result;
        RandomAccessFile raf;
        block13: {
            File indexFileInCache = useCache ? GribCollection.getFileInCache(indexFilename) : new File(indexFilename);
            String indexFilenameInCache = indexFileInCache.getPath();
            String name = GribCollection.makeNameFromIndexFilename(indexFilename);
            raf = null;
            result = null;
            try {
                raf = new RandomAccessFile(indexFilenameInCache, "r");
                GribCollectionType type = GribCdmIndex.getType(raf);
                switch (type) {
                    case GRIB2: {
                        result = Grib2CollectionBuilderFromIndex.readFromIndex(name, raf, config, dataOnly, logger);
                        break;
                    }
                    case Partition2: {
                        result = Grib2PartitionBuilderFromIndex.createTimePartitionFromIndex(name, raf, config, dataOnly, logger);
                        break;
                    }
                    case GRIB1: {
                        result = Grib1CollectionBuilderFromIndex.readFromIndex(name, raf, config, dataOnly, logger);
                        break;
                    }
                    case Partition1: {
                        result = Grib1PartitionBuilderFromIndex.createTimePartitionFromIndex(name, raf, config, dataOnly, logger);
                        break;
                    }
                    default: {
                        logger.warn("GribCdmIndex.openCdmIndex failed on {} type={}", (Object)indexFilenameInCache, (Object)type);
                        break;
                    }
                }
            }
            catch (Throwable t) {
                logger.warn("GribCdmIndex.openCdmIndex failed on " + indexFilenameInCache, t);
                if (raf == null) break block13;
                try {
                    raf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (result == null && raf != null) {
            try {
                raf.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return result;
    }

    public static GribCollection openGribCollectionFromMCollection(boolean isGrib1, MCollection dcm, CollectionUpdateType updateType, Formatter errlog, Logger logger) throws IOException {
        FeatureCollectionConfig config = (FeatureCollectionConfig)dcm.getAuxInfo("fcConfig");
        if (updateType == CollectionUpdateType.never || dcm instanceof CollectionSingleIndexFile) {
            return GribCdmIndex.openCdmIndex(dcm.getIndexFilename(), config, false, logger);
        }
        boolean changed = GribCdmIndex.updateGribCollectionFromMCollection(isGrib1, dcm, updateType, errlog, logger);
        return GribCdmIndex.openCdmIndex(dcm.getIndexFilename(), config, false, logger);
    }

    public static boolean updateGribCollectionFromMCollection(boolean isGrib1, MCollection dcm, CollectionUpdateType updateType, Formatter errlog, Logger logger) throws IOException {
        boolean changed;
        if (updateType == CollectionUpdateType.never || dcm instanceof CollectionSingleIndexFile) {
            return false;
        }
        if (isGrib1) {
            Grib1CollectionBuilder builder;
            changed = dcm.isLeaf() ? (builder = new Grib1CollectionBuilder(dcm.getCollectionName(), dcm, logger)).updateNeeded(updateType) && builder.createIndex(errlog) : (builder = new Grib1PartitionBuilder(dcm.getCollectionName(), new File(dcm.getRoot()), (PartitionManager)dcm, logger)).updateNeeded(updateType) && builder.createPartitionedIndex(updateType, updateType, errlog);
        } else if (dcm.isLeaf()) {
            Grib2CollectionBuilder builder = new Grib2CollectionBuilder(dcm.getCollectionName(), dcm, logger);
            changed = builder.updateNeeded(updateType) && builder.createIndex(errlog);
        } else {
            Grib2PartitionBuilder builder = new Grib2PartitionBuilder(dcm.getCollectionName(), new File(dcm.getRoot()), (PartitionManager)dcm, logger);
            boolean bl = changed = builder.updateNeeded(updateType) && builder.createPartitionedIndex(updateType, updateType, errlog);
        }
        if (errlog != null) {
            errlog.format("GribCollection %s was recreated %s%n", dcm.getCollectionName(), changed);
        }
        return changed;
    }

    public static boolean updateGribCollection(FeatureCollectionConfig config, CollectionUpdateType updateType, Logger logger) throws IOException {
        boolean changed;
        boolean isGrib1;
        long start = System.currentTimeMillis();
        Formatter errlog = new Formatter();
        CollectionSpecParser specp = new CollectionSpecParser(config.spec, errlog);
        Path rootPath = Paths.get(specp.getRootDir(), new String[0]);
        boolean bl = isGrib1 = config.type == FeatureCollectionType.GRIB1;
        if (config.ptype == FeatureCollectionConfig.PartitionType.none) {
            Grib1CollectionBuilder builder;
            CollectionAbstract dcm = specp.wantSubdirs() ? new CollectionGeneral(config.name, rootPath, config.olderThan, logger) : new DirectoryCollection(config.name, rootPath, config.olderThan, logger);
            dcm.putAuxInfo("fcConfig", config);
            if (specp.getFilter() != null) {
                dcm.setStreamFilter(new StreamFilter(specp.getFilter()));
            }
            changed = isGrib1 ? (builder = new Grib1CollectionBuilder(dcm.getCollectionName(), dcm, logger)).updateNeeded(updateType) && builder.createIndex(errlog) : (builder = new Grib2CollectionBuilder(dcm.getCollectionName(), dcm, logger)).updateNeeded(updateType) && builder.createIndex(errlog);
        } else if (specp.wantSubdirs()) {
            DirectoryPartition dpart = new DirectoryPartition(config, rootPath, new GribCdmIndex(logger), logger);
            dpart.putAuxInfo("fcConfig", config);
            changed = GribCdmIndex.updateDirectoryCollectionRecurse(isGrib1, dpart, config, updateType, logger);
        } else {
            changed = GribCdmIndex.updateLeafCollection(isGrib1, config, updateType, logger, rootPath);
        }
        long took = System.currentTimeMillis() - start;
        logger.info("updateGribCollection {} changed {} took {} msecs", new Object[]{config.name, changed, took});
        return changed;
    }

    private static boolean updateDirectoryCollectionRecurse(boolean isGrib1, DirectoryPartition dpart, FeatureCollectionConfig config, CollectionUpdateType forceCollection, Logger logger) throws IOException {
        GribPartitionBuilder builder;
        if (forceCollection == CollectionUpdateType.never) {
            return false;
        }
        Path idxFile = dpart.getIndexPath();
        if (Files.exists(idxFile, new LinkOption[0])) {
            if (forceCollection == CollectionUpdateType.nocheck) {
                return false;
            }
            boolean bad = false;
            try (RandomAccessFile raf = new RandomAccessFile(idxFile.toString(), "r");){
                GribCollectionType type = GribCdmIndex.getType(raf);
                assert (type == (isGrib1 ? GribCollectionType.Partition1 : GribCollectionType.Partition2));
            }
            catch (IOException ioe) {
                bad = true;
            }
            if (bad) {
                Files.delete(idxFile);
            }
        }
        for (MCollection part : dpart.makePartitions(forceCollection)) {
            part.putAuxInfo("fcConfig", config);
            try {
                if (part.isLeaf()) {
                    Path partPath = Paths.get(part.getRoot(), new String[0]);
                    GribCdmIndex.updateLeafCollection(isGrib1, config, forceCollection, logger, partPath);
                    continue;
                }
                GribCdmIndex.updateDirectoryCollectionRecurse(isGrib1, (DirectoryPartition)part, config, forceCollection, logger);
            }
            catch (Throwable t) {
                logger.warn("Error making partition " + part.getRoot(), t);
            }
        }
        Formatter errlog = new Formatter();
        boolean changed = isGrib1 ? (builder = new Grib1PartitionBuilder(dpart.getCollectionName(), new File(dpart.getRoot()), dpart, logger)).updateNeeded(forceCollection) && builder.createPartitionedIndex(forceCollection, CollectionUpdateType.never, errlog) : (builder = new Grib2PartitionBuilder(dpart.getCollectionName(), new File(dpart.getRoot()), dpart, logger)).updateNeeded(forceCollection) && builder.createPartitionedIndex(forceCollection, CollectionUpdateType.never, errlog);
        return changed;
    }

    private static boolean updateLeafCollection(boolean isGrib1, FeatureCollectionConfig config, CollectionUpdateType forceCollection, Logger logger, Path dirPath) throws IOException {
        if (config.ptype == FeatureCollectionConfig.PartitionType.file) {
            return GribCdmIndex.updateFilePartition(isGrib1, config, forceCollection, logger, dirPath);
        }
        return GribCdmIndex.updateLeafDirectoryCollection(isGrib1, config, forceCollection, logger, dirPath);
    }

    private static boolean updateLeafDirectoryCollection(boolean isGrib1, FeatureCollectionConfig config, CollectionUpdateType forceCollection, Logger logger, Path dirPath) throws IOException {
        Grib1CollectionBuilder builder;
        Path idxFile;
        if (forceCollection == CollectionUpdateType.never) {
            return false;
        }
        Formatter errlog = new Formatter();
        CollectionSpecParser specp = new CollectionSpecParser(config.spec, errlog);
        DirectoryCollection dcm = new DirectoryCollection(config.name, dirPath, config.olderThan, logger);
        dcm.setLeaf(true);
        dcm.putAuxInfo("fcConfig", config);
        if (specp.getFilter() != null) {
            dcm.setStreamFilter(new StreamFilter(specp.getFilter()));
        }
        if (Files.exists(idxFile = dcm.getIndexPath(), new LinkOption[0]) && forceCollection == CollectionUpdateType.nocheck) {
            return false;
        }
        boolean changed = isGrib1 ? (builder = new Grib1CollectionBuilder(dcm.getCollectionName(), dcm, logger)).updateNeeded(forceCollection) && builder.createIndex(errlog) : (builder = new Grib2CollectionBuilder(dcm.getCollectionName(), dcm, logger)).updateNeeded(forceCollection) && builder.createIndex(errlog);
        return changed;
    }

    private static boolean updateFilePartition(final boolean isGrib1, final FeatureCollectionConfig config, final CollectionUpdateType updateType, final Logger logger, Path dirPath) throws IOException {
        GribPartitionBuilder builder;
        long start = System.currentTimeMillis();
        final Formatter errlog = new Formatter();
        CollectionSpecParser specp = new CollectionSpecParser(config.spec, errlog);
        FilePartition partition = new FilePartition(config.name, dirPath, config.olderThan, logger);
        partition.putAuxInfo("fcConfig", config);
        if (specp.getFilter() != null) {
            partition.setStreamFilter(new StreamFilter(specp.getFilter()));
        }
        if (updateType != CollectionUpdateType.never) {
            partition.iterateOverMFileCollection(new DirectoryCollection.Visitor(){

                @Override
                public void consume(MFile mfile) {
                    CollectionSingleFile dcm = new CollectionSingleFile(mfile, logger);
                    dcm.putAuxInfo("fcConfig", config);
                    if (isGrib1) {
                        Grib1CollectionBuilder builder = new Grib1CollectionBuilder(dcm.getCollectionName(), dcm, logger);
                        try {
                            boolean changed = builder.updateNeeded(updateType) && builder.createIndex(errlog);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    } else {
                        Grib2CollectionBuilder builder = new Grib2CollectionBuilder(dcm.getCollectionName(), dcm, logger);
                        try {
                            boolean changed = builder.updateNeeded(updateType) && builder.createIndex(errlog);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        boolean recreated = isGrib1 ? (builder = new Grib1PartitionBuilder(partition.getCollectionName(), new File(partition.getRoot()), partition, logger)).updateNeeded(updateType) && builder.createPartitionedIndex(updateType, CollectionUpdateType.never, errlog) : (builder = new Grib2PartitionBuilder(partition.getCollectionName(), new File(partition.getRoot()), partition, logger)).updateNeeded(updateType) && builder.createPartitionedIndex(updateType, CollectionUpdateType.never, errlog);
        long took = System.currentTimeMillis() - start;
        String collectionName = partition.getCollectionName();
        if (recreated) {
            logger.info("RewriteFilePartition {} took {} msecs", (Object)collectionName, (Object)took);
        }
        return recreated;
    }

    public static GribCollection openGribCollection(FeatureCollectionConfig config, CollectionUpdateType updateType, Logger logger) throws IOException {
        boolean didit = GribCdmIndex.updateGribCollection(config, updateType, logger);
        File idxFile = GribCollection.makeTopIndexFileFromConfig(config);
        return GribCdmIndex.openCdmIndex(idxFile.getPath(), config, true, logger);
    }

    public static boolean makeIndex(FeatureCollectionConfig config, Formatter errlog, Path topPath) throws IOException {
        return false;
    }

    public static boolean moveCdmIndex(String indexFilename, Logger logger) throws IOException {
        return false;
    }

    public static GribCollection makeGribCollectionFromRaf(RandomAccessFile raf, FeatureCollectionConfig config, CollectionUpdateType updateType, Logger logger) throws IOException {
        GribCollection result;
        boolean isGrib1 = false;
        boolean isGrib2 = Grib2RecordScanner.isValidFile(raf);
        if (!isGrib2) {
            isGrib1 = Grib1RecordScanner.isValidFile(raf);
        }
        if (isGrib1 || isGrib2) {
            result = GribCdmIndex.openGribCollectionFromDataFile(isGrib1, raf, config, updateType, null, logger);
            raf.close();
        } else {
            result = GribCdmIndex.openGribCollectionFromIndexFile(raf, config, true, logger);
        }
        return result;
    }

    private static GribCollection openGribCollectionFromDataFile(boolean isGrib1, RandomAccessFile dataRaf, FeatureCollectionConfig config, CollectionUpdateType updateType, Formatter errlog, Logger logger) throws IOException {
        String filename = dataRaf.getLocation();
        File dataFile = new File(filename);
        MFileOS mfile = new MFileOS(dataFile);
        return GribCdmIndex.openGribCollectionFromDataFile(isGrib1, mfile, updateType, config, errlog, logger);
    }

    public static GribCollection openGribCollectionFromDataFile(boolean isGrib1, MFile mfile, CollectionUpdateType updateType, FeatureCollectionConfig config, Formatter errlog, Logger logger) throws IOException {
        GribCollectionBuilder builder;
        CollectionSingleFile dcm = new CollectionSingleFile(mfile, logger);
        dcm.putAuxInfo("fcConfig", config);
        if (isGrib1) {
            builder = new Grib1CollectionBuilder(dcm.getCollectionName(), dcm, logger);
            boolean changed = builder.updateNeeded(updateType) && builder.createIndex(errlog);
        } else {
            builder = new Grib2CollectionBuilder(dcm.getCollectionName(), dcm, logger);
            boolean changed = builder.updateNeeded(updateType) && builder.createIndex(errlog);
        }
        GribCollection result = GribCdmIndex.openCdmIndex(dcm.getIndexFilename(), config, true, logger);
        if (result != null) {
            return result;
        }
        if (updateType == CollectionUpdateType.never) {
            return null;
        }
        if (updateType == CollectionUpdateType.always) {
            return null;
        }
        return GribCdmIndex.openGribCollectionFromDataFile(isGrib1, mfile, CollectionUpdateType.always, config, errlog, logger);
    }

    public static GribCollection openGribCollectionFromIndexFile(RandomAccessFile indexRaf, FeatureCollectionConfig config, boolean dataOnly, Logger logger) throws IOException {
        GribCollectionType type = GribCdmIndex.getType(indexRaf);
        String location = indexRaf.getLocation();
        File f = new File(location);
        int pos = f.getName().lastIndexOf(".");
        String name = pos > 0 ? f.getName().substring(0, pos) : f.getName();
        switch (type) {
            case Partition1: {
                return Grib1PartitionBuilderFromIndex.createTimePartitionFromIndex(name, indexRaf, config, dataOnly, logger);
            }
            case GRIB1: {
                return Grib1CollectionBuilderFromIndex.readFromIndex(name, indexRaf, config, dataOnly, logger);
            }
            case Partition2: {
                return Grib2PartitionBuilderFromIndex.createTimePartitionFromIndex(name, indexRaf, config, dataOnly, logger);
            }
            case GRIB2: {
                return Grib2CollectionBuilderFromIndex.readFromIndex(name, indexRaf, config, dataOnly, logger);
            }
        }
        return null;
    }

    public GribCdmIndex(Logger logger) {
        this.logger = logger;
    }

    @Override
    public boolean readChildren(Path indexFile, IndexReader.AddChildCallback callback) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(indexFile.toString(), "r");){
            GribCollectionType type = GribCdmIndex.getType(raf);
            if ((type == GribCollectionType.Partition1 || type == GribCollectionType.Partition2) && this.openIndex(raf, this.logger)) {
                String topDir = this.gribCollectionIndex.getTopDir();
                int n = this.gribCollectionIndex.getMfilesCount();
                for (int i = 0; i < n; ++i) {
                    GribCollectionProto.MFile mfilep = this.gribCollectionIndex.getMfiles(i);
                    callback.addChild(topDir, mfilep.getFilename(), mfilep.getLastModified());
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public boolean isPartition(Path indexFile) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(indexFile.toString(), "r");){
            GribCollectionType type = GribCdmIndex.getType(raf);
            boolean bl = type == GribCollectionType.Partition1 || type == GribCollectionType.Partition2;
            return bl;
        }
    }

    @Override
    public boolean readMFiles(Path indexFile, List<MFile> result) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(indexFile.toString(), "r");){
            if (this.openIndex(raf, this.logger)) {
                File protoDir = new File(this.gribCollectionIndex.getTopDir());
                int n = this.gribCollectionIndex.getMfilesCount();
                for (int i = 0; i < n; ++i) {
                    GribCollectionProto.MFile mfilep = this.gribCollectionIndex.getMfiles(i);
                    result.add(new GcMFile(protoDir, mfilep.getFilename(), mfilep.getLastModified(), mfilep.getIndex()));
                }
            }
            boolean bl = true;
            return bl;
        }
    }

    private boolean openIndex(RandomAccessFile indexRaf, Logger logger) {
        try {
            indexRaf.order(0);
            indexRaf.seek(0L);
            this.magic = new byte["Grib2Collectio2Index".getBytes(CDM.utf8Charset).length];
            indexRaf.readFully(this.magic);
            this.version = indexRaf.readInt();
            long recordLength = indexRaf.readLong();
            if (recordLength > Integer.MAX_VALUE) {
                logger.error("Grib2Collection {}: invalid recordLength size {}", (Object)indexRaf.getLocation(), (Object)recordLength);
                return false;
            }
            indexRaf.skipBytes(recordLength);
            int size = NcStream.readVInt(indexRaf);
            if (size < 0 || size > 100000000) {
                logger.warn("GribCdmIndex {}: invalid index size {}", (Object)indexRaf.getLocation(), (Object)size);
                return false;
            }
            byte[] m = new byte[size];
            indexRaf.readFully(m);
            this.gribCollectionIndex = GribCollectionProto.GribCollection.parseFrom(m);
            return true;
        }
        catch (Throwable t) {
            logger.error("Error reading index " + indexRaf.getLocation(), t);
            return false;
        }
    }

    public static void main2(String[] args) throws IOException {
        Logger logger = LoggerFactory.getLogger((String)"test");
        PartitionManagerFromIndexDirectory partition = new PartitionManagerFromIndexDirectory("NCDC-gfs4_all", new FeatureCollectionConfig(), new File("B:/ncdc/gfs4_all/"), logger);
        Grib1PartitionBuilder builder = new Grib1PartitionBuilder("NCDC-gfs4_all", new File(partition.getRoot()), partition, logger);
        builder.createPartitionedIndex(CollectionUpdateType.nocheck, CollectionUpdateType.never, new Formatter());
    }

    public static void main(String[] args) throws IOException {
        Logger logger = LoggerFactory.getLogger((String)"test");
        FeatureCollectionConfig config = new FeatureCollectionConfig("RFC", "grib/NPVU/RFC", FeatureCollectionType.GRIB1, "B:/motherlode/rfc/**/.*grib1$", "yyyyMMdd#.grib1#", null, "directory", null, null);
        boolean changed = GribCdmIndex.updateGribCollection(config, CollectionUpdateType.test, logger);
        System.out.printf("changed = %s%n", changed);
    }

    public static enum GribCollectionType {
        GRIB1,
        GRIB2,
        Partition1,
        Partition2,
        none;

    }
}

