/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.internal.metrics;

import io.jaegertracing.internal.metrics.Counter;
import io.jaegertracing.internal.metrics.Gauge;
import io.jaegertracing.internal.metrics.Metrics;
import io.jaegertracing.internal.metrics.Timer;
import io.jaegertracing.spi.MetricsFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class InMemoryMetricsFactory
implements MetricsFactory {
    private Map<String, AtomicLong> counters = new ConcurrentHashMap<String, AtomicLong>();
    private Map<String, AtomicLong> timers = new ConcurrentHashMap<String, AtomicLong>();
    private Map<String, AtomicLong> gauges = new ConcurrentHashMap<String, AtomicLong>();

    @Override
    public Counter createCounter(String name, Map<String, String> tags) {
        final AtomicLong value = new AtomicLong(0L);
        this.counters.put(Metrics.addTagsToMetricName(name, tags), value);
        return new Counter(){

            @Override
            public void inc(long delta) {
                value.addAndGet(delta);
            }
        };
    }

    @Override
    public Timer createTimer(String name, Map<String, String> tags) {
        final AtomicLong value = new AtomicLong(0L);
        this.timers.put(Metrics.addTagsToMetricName(name, tags), value);
        return new Timer(){

            @Override
            public void durationMicros(long time) {
                value.addAndGet(time);
            }
        };
    }

    @Override
    public Gauge createGauge(String name, Map<String, String> tags) {
        final AtomicLong value = new AtomicLong(0L);
        this.gauges.put(Metrics.addTagsToMetricName(name, tags), value);
        return new Gauge(){

            @Override
            public void update(long amount) {
                value.getAndSet(amount);
            }
        };
    }

    public long getCounter(String name, String tags) {
        return this.getValue(this.counters, name, tags);
    }

    public long getCounter(String name, Map<String, String> tags) {
        return this.getValue(this.counters, name, tags);
    }

    public long getGauge(String name, String tags) {
        return this.getValue(this.gauges, name, tags);
    }

    public long getGauge(String name, Map<String, String> tags) {
        return this.getValue(this.gauges, name, tags);
    }

    public long getTimer(String name, String tags) {
        return this.getValue(this.timers, name, tags);
    }

    public long getTimer(String name, Map<String, String> tags) {
        return this.getValue(this.timers, name, tags);
    }

    private long getValue(Map<String, AtomicLong> collection, String name, String tags) {
        if (null == tags || tags.isEmpty()) {
            return this.getValue(collection, name);
        }
        String[] entries = tags.split(",");
        HashMap<String, String> tagsAsMap = new HashMap<String, String>(entries.length);
        for (String entry : entries) {
            String[] keyValue = entry.split("=");
            if (keyValue.length == 2) {
                tagsAsMap.put(keyValue[0], keyValue[1]);
                continue;
            }
            tagsAsMap.put(keyValue[0], "");
        }
        return this.getValue(collection, Metrics.addTagsToMetricName(name, tagsAsMap));
    }

    private long getValue(Map<String, AtomicLong> collection, String name, Map<String, String> tags) {
        return this.getValue(collection, Metrics.addTagsToMetricName(name, tags));
    }

    private long getValue(Map<String, AtomicLong> collection, String name) {
        AtomicLong value = collection.get(name);
        if (null == value) {
            return -1L;
        }
        return value.get();
    }
}

