/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.util;

import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

public final class BufferFormat
extends Enum<BufferFormat> {
    public static final /* enum */ BufferFormat UINT_8 = new BufferFormat(1, 0, "B");
    public static final /* enum */ BufferFormat INT_8 = new BufferFormat(1, 0, "b");
    public static final /* enum */ BufferFormat UINT_16 = new BufferFormat(2, 1, "H");
    public static final /* enum */ BufferFormat INT_16 = new BufferFormat(2, 1, "h");
    public static final /* enum */ BufferFormat UINT_32 = new BufferFormat(4, 2, "I");
    public static final /* enum */ BufferFormat INT_32 = new BufferFormat(4, 2, "i");
    public static final /* enum */ BufferFormat UINT_64 = new BufferFormat(8, 3, "L");
    public static final /* enum */ BufferFormat INT_64 = new BufferFormat(8, 3, "l");
    public static final /* enum */ BufferFormat HALF_FLOAT = new BufferFormat(2, 1, "e");
    public static final /* enum */ BufferFormat FLOAT = new BufferFormat(4, 2, "f");
    public static final /* enum */ BufferFormat DOUBLE = new BufferFormat(8, 3, "d");
    public static final /* enum */ BufferFormat UNICODE = new BufferFormat(4, 2, "u");
    public static final /* enum */ BufferFormat CHAR = new BufferFormat(1, 0, "c");
    public static final /* enum */ BufferFormat BOOLEAN = new BufferFormat(1, 0, "?");
    public static final /* enum */ BufferFormat OTHER = new BufferFormat(-1, 0, null);
    public static final TruffleString T_UINT_8_TYPE_CODE;
    public static final TruffleString T_UNICODE_TYPE_CODE_U;
    public static final TruffleString T_UNICODE_TYPE_CODE_W;
    public final int bytesize;
    public final int shift;
    public final TruffleString baseTypeCode;
    private static final /* synthetic */ BufferFormat[] $VALUES;

    public static BufferFormat[] values() {
        return (BufferFormat[])$VALUES.clone();
    }

    public static BufferFormat valueOf(String name) {
        return Enum.valueOf(BufferFormat.class, name);
    }

    private BufferFormat(int bytesize, int shift, String baseTypeCode) {
        assert (bytesize == -1 || bytesize == 1 << shift);
        this.bytesize = bytesize;
        this.shift = shift;
        this.baseTypeCode = PythonUtils.toTruffleStringUncached(baseTypeCode);
    }

    public static BufferFormat forMemoryView(TruffleString formatString, TruffleString.CodePointLengthNode lengthNode, TruffleString.CodePointAtIndexNode atIndexNode) {
        char fmtchar;
        int length = lengthNode.execute((AbstractTruffleString)formatString, PythonUtils.TS_ENCODING);
        if (length == 1) {
            fmtchar = (char)atIndexNode.execute((AbstractTruffleString)formatString, 0, PythonUtils.TS_ENCODING);
        } else if (length == 2 && atIndexNode.execute((AbstractTruffleString)formatString, 0, PythonUtils.TS_ENCODING) == 64) {
            fmtchar = (char)atIndexNode.execute((AbstractTruffleString)formatString, 1, PythonUtils.TS_ENCODING);
        } else {
            return OTHER;
        }
        switch (fmtchar) {
            case 'N': 
            case 'P': {
                return UINT_64;
            }
            case 'n': {
                return INT_64;
            }
            case '?': {
                return BOOLEAN;
            }
            case 'c': {
                return CHAR;
            }
        }
        BufferFormat format = BufferFormat.fromCharCommon(fmtchar);
        return format != null ? format : OTHER;
    }

    public static BufferFormat forArray(TruffleString formatString, TruffleString.CodePointLengthNode lengthNode, TruffleString.CodePointAtIndexNode atIndexNode) {
        int length = lengthNode.execute((AbstractTruffleString)formatString, PythonUtils.TS_ENCODING);
        if (length == 1) {
            char fmtchar = (char)atIndexNode.execute((AbstractTruffleString)formatString, 0, PythonUtils.TS_ENCODING);
            if (fmtchar == 'u') {
                return UNICODE;
            }
            return BufferFormat.fromCharCommon(fmtchar);
        }
        return null;
    }

    private static BufferFormat fromCharCommon(char fmtchar) {
        switch (fmtchar) {
            case 'B': {
                return UINT_8;
            }
            case 'b': {
                return INT_8;
            }
            case 'H': {
                return UINT_16;
            }
            case 'h': {
                return INT_16;
            }
            case 'I': {
                return UINT_32;
            }
            case 'i': {
                return INT_32;
            }
            case 'L': 
            case 'Q': {
                return UINT_64;
            }
            case 'l': 
            case 'q': {
                return INT_64;
            }
            case 'e': {
                return HALF_FLOAT;
            }
            case 'f': {
                return FLOAT;
            }
            case 'd': {
                return DOUBLE;
            }
        }
        return null;
    }

    public static boolean isFloatingPoint(BufferFormat format) {
        return format == HALF_FLOAT || format == FLOAT || format == DOUBLE;
    }

    private static /* synthetic */ BufferFormat[] $values() {
        return new BufferFormat[]{UINT_8, INT_8, UINT_16, INT_16, UINT_32, INT_32, UINT_64, INT_64, HALF_FLOAT, FLOAT, DOUBLE, UNICODE, CHAR, BOOLEAN, OTHER};
    }

    static {
        $VALUES = BufferFormat.$values();
        T_UINT_8_TYPE_CODE = PythonUtils.tsLiteral("B");
        T_UNICODE_TYPE_CODE_U = PythonUtils.tsLiteral("u");
        T_UNICODE_TYPE_CODE_W = PythonUtils.tsLiteral("w");
    }
}

