/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.models;

import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.revertion.DifferenceReverter;
import com.intellij.history.integration.revertion.Reverter;
import com.intellij.history.integration.ui.models.FileDifferenceModel;
import com.intellij.history.integration.ui.models.HistoryDialogModel;
import com.intellij.history.integration.ui.models.RevisionDataKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lvcs.impl.statistics.LocalHistoryCounter;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class FileHistoryDialogModel
extends HistoryDialogModel {
    public FileHistoryDialogModel(Project p, IdeaGateway gw, LocalHistoryFacade vcs, VirtualFile f) {
        super(p, gw, vcs, f);
    }

    public abstract FileDifferenceModel getDifferenceModel();

    @Override
    public Reverter createReverter() {
        Revision l = this.getLeftRevision();
        Revision r = this.getRightRevision();
        return new DifferenceReverter(this.myProject, this.myVcs, this.myGateway, Revision.getDifferencesBetween(l, r), l);
    }

    @NotNull
    public Set<Long> filterContents(@NotNull String filter2) {
        if (filter2 == null) {
            FileHistoryDialogModel.$$$reportNull$$$0(0);
        }
        Set<Long> set = RevisionDataKt.filterContents(this.myVcs, this.myGateway, this.myFile, ContainerUtil.map(this.getRevisions(), item -> item.revision), filter2, this.myBefore);
        if (set == null) {
            FileHistoryDialogModel.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public LocalHistoryCounter.Kind getKind() {
        LocalHistoryCounter.Kind kind = LocalHistoryCounter.Kind.File;
        if (kind == null) {
            FileHistoryDialogModel.$$$reportNull$$$0(2);
        }
        return kind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/history/integration/ui/models/FileHistoryDialogModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/history/integration/ui/models/FileHistoryDialogModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "filterContents";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "filterContents";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

