/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.util.Objects;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Margins;

public abstract class AbstractEntityImage
extends AbstractTextBlock
implements IEntityImage {
    private final Entity entity;
    private final ISkinParam skinParam;

    public AbstractEntityImage(Entity entity) {
        this.entity = Objects.requireNonNull(entity);
        this.skinParam = entity.getSkinParam();
    }

    @Override
    public boolean isHidden() {
        return this.entity.isHidden();
    }

    protected final Entity getEntity() {
        return this.entity;
    }

    protected final ISkinParam getSkinParam() {
        return this.skinParam;
    }

    @Override
    public final HColor getBackcolor() {
        return this.skinParam.getBackgroundColor();
    }

    protected final Stereotype getStereo() {
        return this.entity.getStereotype();
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        return Margins.NONE;
    }

    @Override
    public double getOverscanX(StringBounder stringBounder) {
        return 0.0;
    }

    public SName getStyleName() {
        return this.entity.getUmlDiagramType().getStyleName();
    }
}

