/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.codec;

import java.io.IOException;
import lombok.Generated;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocIDMerger;
import org.apache.lucene.util.BytesRef;
import org.opensearch.neuralsearch.sparse.accessor.SparseVectorReader;
import org.opensearch.neuralsearch.sparse.cache.CacheKey;
import org.opensearch.neuralsearch.sparse.cache.ForwardIndexCache;
import org.opensearch.neuralsearch.sparse.cache.ForwardIndexCacheItem;
import org.opensearch.neuralsearch.sparse.codec.BinaryDocValuesSub;
import org.opensearch.neuralsearch.sparse.data.SparseVector;

public class SparseBinaryDocValues
extends BinaryDocValues {
    private final DocIDMerger<BinaryDocValuesSub> docIDMerger;
    private long totalLiveDocs;
    private BinaryDocValuesSub current;
    private int docID = -1;

    SparseBinaryDocValues(DocIDMerger<BinaryDocValuesSub> docIdMerger) {
        this.docIDMerger = docIdMerger;
    }

    public int docID() {
        return this.docID;
    }

    public int nextDoc() throws IOException {
        if (this.docIDMerger == null) {
            this.docID = Integer.MAX_VALUE;
            return this.docID;
        }
        this.current = (BinaryDocValuesSub)this.docIDMerger.next();
        this.docID = this.current == null ? Integer.MAX_VALUE : this.current.mappedDocID;
        return this.docID;
    }

    public int advance(int target) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean advanceExact(int target) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long cost() {
        throw new UnsupportedOperationException();
    }

    public BytesRef binaryValue() throws IOException {
        return this.current.getValues().binaryValue();
    }

    public SparseVector cachedSparseVector() throws IOException {
        if (this.current == null) {
            return null;
        }
        CacheKey key = this.current.getKey();
        if (key == null) {
            return null;
        }
        ForwardIndexCacheItem index = (ForwardIndexCacheItem)ForwardIndexCache.getInstance().get(key);
        if (index == null) {
            return null;
        }
        SparseVectorReader reader = index.getReader();
        int oldDocId = this.current.getDocId();
        return reader.read(oldDocId);
    }

    public SparseBinaryDocValues setTotalLiveDocs(long totalLiveDocs) {
        this.totalLiveDocs = totalLiveDocs;
        return this;
    }

    @Generated
    public long getTotalLiveDocs() {
        return this.totalLiveDocs;
    }
}

