/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices.preprocessor;

import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.IRCFComputeDescriptor;
import com.amazon.randomcutforest.parkservices.preprocessor.Preprocessor;
import com.amazon.randomcutforest.parkservices.statistics.Deviation;
import java.util.Arrays;

public class InitialSegmentPreprocessor
extends Preprocessor {
    public InitialSegmentPreprocessor(Preprocessor.Builder<?> builder) {
        super(builder);
        this.initialValues = new double[this.startNormalization][];
        this.initialTimeStamps = new long[this.startNormalization];
    }

    @Override
    public AnomalyDescriptor preProcess(AnomalyDescriptor description, IRCFComputeDescriptor lastAnomalyDescriptor, RandomCutForest forest) {
        this.initialSetup(description, lastAnomalyDescriptor, forest);
        if (this.valuesSeen < this.startNormalization) {
            this.storeInitial(description.getCurrentInput(), description.getInputTimestamp());
            return description;
        }
        if (this.valuesSeen == this.startNormalization) {
            this.dischargeInitial(forest);
        }
        return super.preProcess(description, lastAnomalyDescriptor, forest);
    }

    protected void storeInitial(double[] inputPoint, long timestamp) {
        this.initialTimeStamps[this.valuesSeen] = timestamp;
        this.initialValues[this.valuesSeen] = Arrays.copyOf(inputPoint, inputPoint.length);
        ++this.valuesSeen;
    }

    protected double[] getFactors() {
        double[] factors = null;
        if (InitialSegmentPreprocessor.requireInitialSegment(false, this.transformMethod)) {
            int j;
            Deviation[] tempList = new Deviation[this.inputLength];
            for (j = 0; j < this.inputLength; ++j) {
                tempList[j] = new Deviation(this.deviationList[j].getDiscount());
            }
            for (int i = 0; i < this.initialValues.length; ++i) {
                for (int j2 = 0; j2 < this.inputLength; ++j2) {
                    double value = this.transformMethod == TransformMethod.NORMALIZE ? this.initialValues[i][j2] : (i == 0 ? 0.0 : this.initialValues[i][j2] - this.initialValues[i - 1][j2]);
                    tempList[j2].update(value);
                }
            }
            factors = new double[this.inputLength];
            for (j = 0; j < this.inputLength; ++j) {
                factors[j] = tempList[j].getDeviation();
            }
        }
        return factors;
    }

    protected void dischargeInitial(RandomCutForest forest) {
        Deviation tempTimeDeviation = new Deviation();
        for (int i = 0; i < this.initialTimeStamps.length - 1; ++i) {
            tempTimeDeviation.update(this.initialTimeStamps[i + 1] - this.initialTimeStamps[i]);
        }
        double timeFactor = tempTimeDeviation.getDeviation();
        double[] factors = this.getFactors();
        for (int i = 0; i < this.valuesSeen; ++i) {
            double[] scaledInput = this.getScaledInput(this.initialValues[i], this.initialTimeStamps[i], factors, timeFactor);
            this.updateState(this.initialValues[i], scaledInput, this.initialTimeStamps[i], this.previousTimeStamps[this.shingleSize - 1]);
            this.dataQuality.update(1.0);
            forest.update(scaledInput);
        }
        this.initialTimeStamps = null;
        this.initialValues = null;
    }
}

