"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.clearOldVersionCookieValue = clearOldVersionCookieValue;
exports.getSecurityCookieOptions = getSecurityCookieOptions;
/*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */

function getSecurityCookieOptions(config) {
  return {
    name: config.cookie.name,
    encryptionKey: config.cookie.password,
    validate: sessionStorage => {
      sessionStorage = sessionStorage;
      if (sessionStorage === undefined) {
        return {
          isValid: false,
          path: '/'
        };
      }

      // TODO: with setting redirect attributes to support OIDC and SAML,
      //       we need to do additional cookie validation in AuthenticationHandlers.
      // if SAML fields present
      if (sessionStorage.saml && sessionStorage.saml.requestId) {
        return {
          isValid: true,
          path: '/'
        };
      }

      // if OIDC fields present
      if (sessionStorage.oidc) {
        return {
          isValid: true,
          path: '/'
        };
      }
      if (sessionStorage.expiryTime === undefined || sessionStorage.expiryTime < Date.now()) {
        return {
          isValid: false,
          path: '/'
        };
      }
      return {
        isValid: true,
        path: '/'
      };
    },
    isSecure: config.cookie.secure,
    sameSite: config.cookie.isSameSite || undefined
  };
}
function clearOldVersionCookieValue(config) {
  if (config.cookie.secure) {
    return 'security_authentication=; Max-Age=0; Expires=Thu, 01 Jan 1970 00:00:00 GMT; Secure; HttpOnly; Path=/';
  } else {
    return 'security_authentication=; Max-Age=0; Expires=Thu, 01 Jan 1970 00:00:00 GMT; HttpOnly; Path=/';
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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