/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.stats;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.forecast.caching.ForecastCacheProvider;
import org.opensearch.forecast.caching.ForecastPriorityCache;
import org.opensearch.forecast.settings.ForecastSettings;
import org.opensearch.timeseries.ml.ModelState;

public class ForecastModelsOnNodeSupplier
implements Supplier<List<Map<String, Object>>> {
    private ForecastCacheProvider forecastCache;
    private volatile int forecastNumModelsToReturn;
    public static Set<String> MODEL_STATE_STAT_KEYS = new HashSet<String>(Arrays.asList("model_id", ModelState.MODEL_TYPE_KEY, "entity", ModelState.LAST_USED_TIME_KEY, ModelState.LAST_CHECKPOINT_TIME_KEY, "forecaster_id"));

    public ForecastModelsOnNodeSupplier(ForecastCacheProvider forecastCache, Settings settings, ClusterService clusterService) {
        this.forecastCache = forecastCache;
        this.forecastNumModelsToReturn = (Integer)ForecastSettings.FORECAST_MAX_MODEL_SIZE_PER_NODE.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ForecastSettings.FORECAST_MAX_MODEL_SIZE_PER_NODE, it -> {
            this.forecastNumModelsToReturn = it;
        });
    }

    @Override
    public List<Map<String, Object>> get() {
        Stream<Map> forecastStream = ((ForecastPriorityCache)this.forecastCache.get()).getAllModels().stream().limit(this.forecastNumModelsToReturn).map(modelState -> modelState.getModelStateAsMap().entrySet().stream().filter(entry -> MODEL_STATE_STAT_KEYS.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        return forecastStream.collect(Collectors.toList());
    }
}

