/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.el.ExpressionFactory;

class ExpressionFactoryCache {
    private final AtomicReference<WeakHashMap<ClassLoader, WeakReference<ExpressionFactory>>> factoryCache = new AtomicReference(new WeakHashMap());

    ExpressionFactoryCache() {
    }

    ExpressionFactory getOrCreateExpressionFactory(ClassLoader cl) {
        WeakHashMap<ClassLoader, WeakReference<ExpressionFactory>> newCache;
        WeakHashMap<ClassLoader, WeakReference<ExpressionFactory>> cache;
        ExpressionFactory factory = null;
        do {
            WeakReference<ExpressionFactory> factoryRef;
            if ((factoryRef = (cache = this.factoryCache.get()).get(cl)) != null && (factory = (ExpressionFactory)factoryRef.get()) != null) {
                return factory;
            }
            if (factory == null) {
                factory = ExpressionFactory.newInstance();
            }
            factoryRef = new WeakReference<ExpressionFactory>(factory);
            newCache = new WeakHashMap<ClassLoader, WeakReference<ExpressionFactory>>(cache);
            newCache.put(cl, factoryRef);
        } while (!this.factoryCache.compareAndSet(cache, newCache));
        return factory;
    }
}

