/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.event.internal;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.internal.build.AllowReflection;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.MapBackedClassValue;
import org.hibernate.internal.util.collections.ReadOnlyMap;
import org.hibernate.jpa.event.spi.Callback;
import org.hibernate.jpa.event.spi.CallbackRegistry;
import org.hibernate.jpa.event.spi.CallbackType;

final class CallbackRegistryImpl
implements CallbackRegistry {
    private final ReadOnlyMap<Class<?>, Callback[]> preCreates;
    private final ReadOnlyMap<Class<?>, Callback[]> postCreates;
    private final ReadOnlyMap<Class<?>, Callback[]> preRemoves;
    private final ReadOnlyMap<Class<?>, Callback[]> postRemoves;
    private final ReadOnlyMap<Class<?>, Callback[]> preUpdates;
    private final ReadOnlyMap<Class<?>, Callback[]> postUpdates;
    private final ReadOnlyMap<Class<?>, Callback[]> postLoads;

    public CallbackRegistryImpl(Map<Class<?>, Callback[]> preCreates, Map<Class<?>, Callback[]> postCreates, Map<Class<?>, Callback[]> preRemoves, Map<Class<?>, Callback[]> postRemoves, Map<Class<?>, Callback[]> preUpdates, Map<Class<?>, Callback[]> postUpdates, Map<Class<?>, Callback[]> postLoads) {
        this.preCreates = CallbackRegistryImpl.createBackingMap(preCreates);
        this.postCreates = CallbackRegistryImpl.createBackingMap(postCreates);
        this.preRemoves = CallbackRegistryImpl.createBackingMap(preRemoves);
        this.postRemoves = CallbackRegistryImpl.createBackingMap(postRemoves);
        this.preUpdates = CallbackRegistryImpl.createBackingMap(preUpdates);
        this.postUpdates = CallbackRegistryImpl.createBackingMap(postUpdates);
        this.postLoads = CallbackRegistryImpl.createBackingMap(postLoads);
    }

    private static ReadOnlyMap<Class<?>, Callback[]> createBackingMap(Map<Class<?>, Callback[]> src) {
        return src == null || src.isEmpty() ? ReadOnlyMap.EMPTY : new MapBackedClassValue<Callback[]>(src);
    }

    @Override
    public boolean hasRegisteredCallbacks(Class<?> entityClass, CallbackType callbackType) {
        return this.notEmpty(this.getCallbackMap(callbackType).get(entityClass));
    }

    @Override
    public void preCreate(Object bean) {
        this.callback(this.preCreates.get(bean.getClass()), bean);
    }

    private boolean notEmpty(Callback[] callbacks) {
        return callbacks != null && callbacks.length > 0;
    }

    @Override
    public void postCreate(Object bean) {
        this.callback(this.postCreates.get(bean.getClass()), bean);
    }

    @Override
    public boolean preUpdate(Object bean) {
        return this.callback(this.preUpdates.get(bean.getClass()), bean);
    }

    @Override
    public void postUpdate(Object bean) {
        this.callback(this.postUpdates.get(bean.getClass()), bean);
    }

    @Override
    public void preRemove(Object bean) {
        this.callback(this.preRemoves.get(bean.getClass()), bean);
    }

    @Override
    public void postRemove(Object bean) {
        this.callback(this.postRemoves.get(bean.getClass()), bean);
    }

    @Override
    public boolean postLoad(Object bean) {
        return this.callback(this.postLoads.get(bean.getClass()), bean);
    }

    @Override
    public void release() {
        this.preCreates.dispose();
        this.postCreates.dispose();
        this.preRemoves.dispose();
        this.postRemoves.dispose();
        this.preUpdates.dispose();
        this.postUpdates.dispose();
        this.postLoads.dispose();
    }

    private boolean callback(Callback[] callbacks, Object bean) {
        if (callbacks != null && callbacks.length != 0) {
            for (Callback callback : callbacks) {
                callback.performCallback(bean);
            }
            return true;
        }
        return false;
    }

    private ReadOnlyMap<Class<?>, Callback[]> getCallbackMap(CallbackType callbackType) {
        return switch (callbackType) {
            default -> throw new IncompatibleClassChangeError();
            case CallbackType.PRE_PERSIST -> this.preCreates;
            case CallbackType.POST_PERSIST -> this.postCreates;
            case CallbackType.PRE_REMOVE -> this.preRemoves;
            case CallbackType.POST_REMOVE -> this.postRemoves;
            case CallbackType.PRE_UPDATE -> this.preUpdates;
            case CallbackType.POST_UPDATE -> this.postUpdates;
            case CallbackType.POST_LOAD -> this.postLoads;
        };
    }

    public static class Builder {
        private static final Callback[] NO_CALLBACKS = new Callback[0];
        private final Map<Class<?>, Callback[]> preCreates = new HashMap();
        private final Map<Class<?>, Callback[]> postCreates = new HashMap();
        private final Map<Class<?>, Callback[]> preRemoves = new HashMap();
        private final Map<Class<?>, Callback[]> postRemoves = new HashMap();
        private final Map<Class<?>, Callback[]> preUpdates = new HashMap();
        private final Map<Class<?>, Callback[]> postUpdates = new HashMap();
        private final Map<Class<?>, Callback[]> postLoads = new HashMap();

        @AllowReflection
        public void registerCallbacks(Class<?> entityClass, Callback[] callbacks) {
            if (callbacks != null) {
                for (Callback callback : callbacks) {
                    this.addCallback(entityClass, callback);
                }
            }
        }

        public void addCallback(Class<?> entityClass, Callback callback) {
            Map<Class<?>, Callback[]> callbackMap = this.getCallbackMap(callback.getCallbackType());
            Callback[] existingCallbacks = callbackMap.getOrDefault(entityClass, NO_CALLBACKS);
            callbackMap.put(entityClass, ArrayHelper.add(existingCallbacks, callback));
        }

        private Map<Class<?>, Callback[]> getCallbackMap(CallbackType callbackType) {
            return switch (callbackType) {
                default -> throw new IncompatibleClassChangeError();
                case CallbackType.PRE_PERSIST -> this.preCreates;
                case CallbackType.POST_PERSIST -> this.postCreates;
                case CallbackType.PRE_REMOVE -> this.preRemoves;
                case CallbackType.POST_REMOVE -> this.postRemoves;
                case CallbackType.PRE_UPDATE -> this.preUpdates;
                case CallbackType.POST_UPDATE -> this.postUpdates;
                case CallbackType.POST_LOAD -> this.postLoads;
            };
        }

        protected CallbackRegistry build() {
            return new CallbackRegistryImpl(this.preCreates, this.postCreates, this.preRemoves, this.postRemoves, this.preUpdates, this.postUpdates, this.postLoads);
        }
    }
}

