/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.json.AbstractJsonRemoveFunction;
import org.hibernate.dialect.function.json.JsonPathHelper;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.spi.TypeConfiguration;

public class PostgreSQLJsonRemoveFunction
extends AbstractJsonRemoveFunction {
    public PostgreSQLJsonRemoveFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnType, SqlAstTranslator<?> translator) {
        boolean needsCast;
        Expression json = (Expression)arguments.get(0);
        Expression jsonPath = (Expression)arguments.get(1);
        boolean bl = needsCast = !this.isJsonType(json) && AbstractSqlAstTranslator.isParameter(json);
        if (needsCast) {
            sqlAppender.appendSql("cast(");
        }
        json.accept(translator);
        if (needsCast) {
            sqlAppender.appendSql(" as jsonb)");
        }
        sqlAppender.appendSql("#-");
        List<JsonPathHelper.JsonPathElement> jsonPathElements = JsonPathHelper.parseJsonPathElements((String)translator.getLiteralValue(jsonPath));
        sqlAppender.appendSql("array");
        int separator = 91;
        for (JsonPathHelper.JsonPathElement pathElement : jsonPathElements) {
            sqlAppender.appendSql((char)separator);
            if (pathElement instanceof JsonPathHelper.JsonAttribute) {
                JsonPathHelper.JsonAttribute attribute = (JsonPathHelper.JsonAttribute)pathElement;
                sqlAppender.appendSingleQuoteEscapedString(attribute.attribute());
            } else {
                if (pathElement instanceof JsonPathHelper.JsonParameterIndexAccess) {
                    JsonPathHelper.JsonParameterIndexAccess parameterIndexAccess = (JsonPathHelper.JsonParameterIndexAccess)pathElement;
                    String parameterName = parameterIndexAccess.parameterName();
                    throw new QueryException("JSON path [" + String.valueOf(jsonPath) + "] uses parameter [" + parameterName + "] that is not passed");
                }
                sqlAppender.appendSql('\'');
                sqlAppender.appendSql(((JsonPathHelper.JsonIndexAccess)pathElement).index());
                sqlAppender.appendSql('\'');
            }
            separator = 44;
        }
        sqlAppender.appendSql("]::text[]");
    }

    private boolean isJsonType(Expression expression) {
        JdbcMappingContainer expressionType = expression.getExpressionType();
        return expressionType != null && expressionType.getSingleJdbcMapping().getJdbcType().isJson();
    }
}

