/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.streams;

import java.util.Objects;
import org.apache.kafka.common.Uuid;

public record TopicMetadata(Uuid id, String name, int numPartitions) {
    public TopicMetadata(Uuid id, String name, int numPartitions) {
        this.id = Objects.requireNonNull(id);
        if (Uuid.ZERO_UUID.equals((Object)id)) {
            throw new IllegalArgumentException("Topic id cannot be ZERO_UUID.");
        }
        this.name = Objects.requireNonNull(name);
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Topic name cannot be empty.");
        }
        this.numPartitions = numPartitions;
        if (numPartitions <= 0) {
            throw new IllegalArgumentException("Number of partitions must be positive.");
        }
    }
}

