/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DataGridBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DocumentDataHookUp;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ImmutableDataHookUp;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.actions.GridAutoRefresher;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.Formats;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BadgeIconSupplier;
import com.intellij.util.containers.ContainerUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PageAutoRefreshGroup
extends ActionGroup
implements GridAction {
    private final BadgeIconSupplier myIcon = new BadgeIconSupplier(AllIcons.Vcs.History);
    private final List<RefreshIntervalAction> myActions = List.of(new RefreshIntervalAction(0), new RefreshIntervalAction(5), new RefreshIntervalAction(10), new RefreshIntervalAction(30), new RefreshIntervalAction(60), new RefreshIntervalAction(300));

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            PageAutoRefreshGroup.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            PageAutoRefreshGroup.$$$reportNull$$$0(1);
        }
        if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null || dataGrid.getDataHookup() instanceof DocumentDataHookUp || dataGrid.getDataHookup() instanceof ImmutableDataHookUp) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(!GridUtil.hidePageActions(dataGrid, e.getPlace()));
        GridAutoRefresher refresher = GridAutoRefresher.getRefresher(dataGrid);
        e.getPresentation().setIcon(refresher != null ? (refresher.isManuallyPaused() ? this.myIcon.getWarningIcon() : this.myIcon.getSuccessIcon()) : this.myIcon.getOriginalIcon());
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        DataGrid dataGrid;
        DataGrid dataGrid2 = dataGrid = e == null ? null : (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (dataGrid == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                PageAutoRefreshGroup.$$$reportNull$$$0(2);
            }
            return AnAction.EMPTY_ARRAY;
        }
        int intervalSec = GridAutoRefresher.getRefreshInterval(dataGrid);
        GridAutoRefresher refresher = GridAutoRefresher.getRefresher(dataGrid);
        ArrayList<Object> res = new ArrayList<Object>(this.myActions.size() + 4);
        if (refresher != null) {
            res.add(new PauseRefresherAction());
        }
        res.addAll(this.getIntervalActions(intervalSec));
        res.add(Separator.getInstance());
        res.add(new CustomIntervalAction());
        AnAction[] anActionArray = res.toArray(EMPTY_ARRAY);
        if (anActionArray == null) {
            PageAutoRefreshGroup.$$$reportNull$$$0(3);
        }
        return anActionArray;
    }

    @NotNull
    private List<RefreshIntervalAction> getIntervalActions(int intervalSec) {
        if (ContainerUtil.find(this.myActions, a -> a.myIntervalSec == intervalSec) != null) {
            List<RefreshIntervalAction> list = this.myActions;
            if (list == null) {
                PageAutoRefreshGroup.$$$reportNull$$$0(4);
            }
            return list;
        }
        ArrayList<RefreshIntervalAction> actions = new ArrayList<RefreshIntervalAction>(this.myActions.size() + 1);
        actions.addAll(this.myActions);
        actions.add(new RefreshIntervalAction(intervalSec));
        actions.sort(Comparator.comparing(a -> a.myIntervalSec));
        ArrayList<RefreshIntervalAction> arrayList = actions;
        if (arrayList == null) {
            PageAutoRefreshGroup.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/PageAutoRefreshGroup";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/PageAutoRefreshGroup";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntervalActions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class RefreshIntervalAction
    extends ToggleAction
    implements DumbAware,
    GridAction {
        private final int myIntervalSec;

        private RefreshIntervalAction(int intervalSec) {
            this.myIntervalSec = intervalSec;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                RefreshIntervalAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RefreshIntervalAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            e.getPresentation().setEnabledAndVisible(e.getData(DatabaseDataKeys.DATA_GRID_KEY) != null);
            e.getPresentation().setText(this.myIntervalSec == 0 ? DataGridBundle.message((String)"action.disabled.text", (Object[])new Object[0]) : Formats.formatDuration((Duration)Duration.ofSeconds(this.myIntervalSec)));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            DataGrid dataGrid;
            if (e == null) {
                RefreshIntervalAction.$$$reportNull$$$0(2);
            }
            if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null) {
                return false;
            }
            return GridAutoRefresher.getRefreshInterval(dataGrid) == this.myIntervalSec;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            DataGrid dataGrid;
            if (e == null) {
                RefreshIntervalAction.$$$reportNull$$$0(3);
            }
            if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null) {
                return;
            }
            GridAutoRefresher.setRefreshInterval(dataGrid, state ? this.myIntervalSec : 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/PageAutoRefreshGroup$RefreshIntervalAction";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/PageAutoRefreshGroup$RefreshIntervalAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class PauseRefresherAction
    extends ToggleAction
    implements DumbAware,
    GridAction {
        private PauseRefresherAction() {
            super(DataGridBundle.message((String)"action.pause.text", (Object[])new Object[0]));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                PauseRefresherAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                PauseRefresherAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            GridAutoRefresher refresher = GridAutoRefresher.getRefresher((DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY));
            e.getPresentation().setEnabledAndVisible(refresher != null);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            GridAutoRefresher refresher;
            if (e == null) {
                PauseRefresherAction.$$$reportNull$$$0(2);
            }
            return (refresher = GridAutoRefresher.getRefresher((DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY))) != null && refresher.isManuallyPaused();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            GridAutoRefresher refresher;
            if (e == null) {
                PauseRefresherAction.$$$reportNull$$$0(3);
            }
            if ((refresher = GridAutoRefresher.getRefresher((DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY))) != null) {
                refresher.setManuallyPaused(state);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/PageAutoRefreshGroup$PauseRefresherAction";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/PageAutoRefreshGroup$PauseRefresherAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class CustomIntervalAction
    extends DumbAwareAction
    implements GridAction {
        private CustomIntervalAction() {
            super(DataGridBundle.message((String)"action.custom.text", (Object[])new Object[0]));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                CustomIntervalAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CustomIntervalAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabledAndVisible(e.getData(DatabaseDataKeys.DATA_GRID_KEY) != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DataGrid dataGrid;
            if (e == null) {
                CustomIntervalAction.$$$reportNull$$$0(2);
            }
            if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null) {
                return;
            }
            int interval = GridAutoRefresher.getRefreshInterval(dataGrid);
            String res = Messages.showInputDialog((Project)e.getProject(), (String)DataGridBundle.message((String)"dialog.message.update.interval.in.seconds", (Object[])new Object[0]), (String)DataGridBundle.message((String)"dialog.title.custom.update.interval", (Object[])new Object[0]), null, (String)Integer.toString(interval), (InputValidator)new InputValidator(){

                public boolean checkInput(String inputString) {
                    return StringUtil.parseInt((String)inputString, (int)-1) >= 0;
                }

                public boolean canClose(String inputString) {
                    return StringUtil.parseInt((String)inputString, (int)-1) >= 0;
                }
            });
            if (res != null) {
                GridAutoRefresher.setRefreshInterval(dataGrid, StringUtil.parseInt((String)res, (int)0));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/PageAutoRefreshGroup$CustomIntervalAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/PageAutoRefreshGroup$CustomIntervalAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

