/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\f0\u0005\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\nH\u0016J\u0012\u0010\u000b\u001a\f0\u0005\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\nH\u0016J\u0012\u0010\f\u001a\f0\u0005\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\nH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/AutomaticInheritorRenamer;", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamer;", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "newName", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtClass;Ljava/lang/String;)V", "getDialogTitle", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getDialogDescription", "entityName", "kotlin.refactorings.common"})
public final class AutomaticInheritorRenamer
extends AutomaticRenamer {
    public AutomaticInheritorRenamer(@NotNull KtClass klass, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        KtLightClass lightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)klass));
        if (lightClass != null) {
            for (PsiClass inheritorLightClass : ClassInheritorsSearch.search((PsiClass)((PsiClass)lightClass), (boolean)true).findAll()) {
                Intrinsics.checkNotNull((Object)inheritorLightClass);
                PsiElement psiElement = LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)inheritorLightClass));
                PsiNamedElement psiNamedElement = psiElement instanceof PsiNamedElement ? (PsiNamedElement)psiElement : null;
                if ((psiNamedElement != null ? psiNamedElement.getName() : null) == null) continue;
                PsiElement psiElement2 = LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)inheritorLightClass));
                Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type com.intellij.psi.PsiNamedElement");
                this.myElements.add((PsiNamedElement)psiElement2);
            }
        }
        this.suggestAllNames(klass.getName(), newName);
    }

    @NotNull
    public String getDialogTitle() {
        String string = RefactoringBundle.message((String)"rename.inheritors.title");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getDialogDescription() {
        String string = JavaRefactoringBundle.message((String)"rename.inheritors.with.the.following.names.to.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String entityName() {
        String string = JavaRefactoringBundle.message((String)"entity.name.inheritor", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

