/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.intentions.shared;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.codeinsight.utils.AddBracesUtils;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@IntellijInternalApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\tH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/AddBracesIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtElement;", "<init>", "()V", "isApplicableTo", "", "element", "caretOffset", "", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "getTargetExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "caretLocation", "kotlin.code-insight.intentions.shared"})
@ApiStatus.Internal
public final class AddBracesIntention
extends SelfTargetingIntention<KtElement> {
    public AddBracesIntention() {
        super(KtElement.class, KotlinBundle.lazyMessage((String)"add.braces", (Object[])new Object[0]), null, 4, null);
    }

    @Override
    public boolean isApplicableTo(@NotNull KtElement element, int caretOffset) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtExpression ktExpression = this.getTargetExpression(element, caretOffset);
        if (ktExpression == null) {
            return false;
        }
        KtExpression expression = ktExpression;
        if (expression instanceof KtBlockExpression) {
            return false;
        }
        PsiElement parent2 = expression.getParent();
        if (parent2 instanceof KtContainerNode) {
            String string = KotlinPsiUtilsKt.getControlFlowElementDescription((KtContainerNode)parent2);
            if (string == null) {
                return false;
            }
            String description = string;
            Object[] objectArray = new Object[]{description};
            this.setTextGetter((Function0<String>)KotlinBundle.lazyMessage((String)"add.braces.to.0.statement", (Object[])objectArray));
            bl = true;
        } else if (parent2 instanceof KtWhenEntry) {
            this.setTextGetter((Function0<String>)KotlinBundle.lazyMessage((String)"add.braces.to.when.entry", (Object[])new Object[0]));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void applyTo(@NotNull KtElement element, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (editor == null) {
            throw new IllegalArgumentException("This intention requires an editor");
        }
        KtExpression ktExpression = this.getTargetExpression(element, editor.getCaretModel().getOffset());
        if (ktExpression == null) {
            return;
        }
        KtExpression expression = ktExpression;
        AddBracesUtils.INSTANCE.addBraces(element, expression);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final KtExpression getTargetExpression(KtElement $this$getTargetExpression, int caretLocation) {
        KtExpression ktExpression;
        KtElement ktElement = $this$getTargetExpression;
        if (ktElement instanceof KtIfExpression) {
            KtExpression ktExpression2 = ((KtIfExpression)$this$getTargetExpression).getThen();
            if (ktExpression2 == null) {
                return null;
            }
            KtExpression thenExpr = ktExpression2;
            KtExpression elseExpr = ((KtIfExpression)$this$getTargetExpression).getElse();
            if (elseExpr != null) {
                PsiElement psiElement = ((KtIfExpression)$this$getTargetExpression).getElseKeyword();
                if (psiElement == null) return null;
                if (caretLocation >= PsiUtilsKt.getStartOffset((PsiElement)psiElement)) {
                    ktExpression = elseExpr;
                    return ktExpression;
                }
            }
            ktExpression = thenExpr;
            return ktExpression;
        }
        if (ktElement instanceof KtLoopExpression) {
            ktExpression = ((KtLoopExpression)$this$getTargetExpression).getBody();
            return ktExpression;
        }
        if (!(ktElement instanceof KtWhenEntry)) return null;
        ktExpression = ((KtWhenEntry)$this$getTargetExpression).getExpression();
        return ktExpression;
    }
}

