/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director;

import java.util.Map;
import org.eclipse.equinox.internal.p2.director.Slicer;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.IQueryable;

public class PermissiveSlicer
extends Slicer {
    private final boolean includeOptionalDependencies;
    private final boolean everythingGreedy;
    private final boolean considerFilter;
    private final boolean considerOnlyStrictDependency;
    private final boolean evalFilterTo;
    private final boolean onlyFilteredRequirements;

    public PermissiveSlicer(IQueryable<IInstallableUnit> input, Map<String, String> context, boolean includeOptionalDependencies, boolean everythingGreedy, boolean evalFilterTo, boolean considerOnlyStrictDependency, boolean onlyFilteredRequirements) {
        super(input, context, true);
        this.considerFilter = context != null && context.size() > 1;
        this.includeOptionalDependencies = includeOptionalDependencies;
        this.everythingGreedy = everythingGreedy;
        this.evalFilterTo = evalFilterTo;
        this.considerOnlyStrictDependency = considerOnlyStrictDependency;
        this.onlyFilteredRequirements = onlyFilteredRequirements;
    }

    @Override
    protected boolean isApplicable(IInstallableUnit iu) {
        if (this.considerFilter) {
            return super.isApplicable(iu);
        }
        return iu.getFilter() == null || this.evalFilterTo;
    }

    @Override
    protected boolean isApplicable(IRequirement req) {
        if (!this.includeOptionalDependencies && req.getMin() == 0) {
            return false;
        }
        if (this.considerOnlyStrictDependency && !RequiredCapability.isStrictVersionRequirement((IMatchExpression)req.getMatches())) {
            return false;
        }
        IMatchExpression filter = req.getFilter();
        if (filter == null) {
            return !this.onlyFilteredRequirements;
        }
        return this.considerFilter ? filter.isMatch((Object)this.selectionContext) : this.evalFilterTo;
    }

    @Override
    protected boolean isGreedy(IRequirement req) {
        return this.everythingGreedy || super.isGreedy(req);
    }
}

