/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.project.DuplicateArtifactAttachmentException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

public class PluginExecutionException
extends PluginManagerException {
    private final MojoExecution mojoExecution;

    public PluginExecutionException(MojoExecution mojoExecution, MavenProject project2, String message) {
        super(mojoExecution.getMojoDescriptor(), project2, message);
        this.mojoExecution = mojoExecution;
    }

    public PluginExecutionException(MojoExecution mojoExecution, MavenProject project2, String message, Throwable cause) {
        super(mojoExecution.getMojoDescriptor(), project2, message, cause);
        this.mojoExecution = mojoExecution;
    }

    public PluginExecutionException(MojoExecution mojoExecution, MavenProject project2, Exception cause) {
        super(mojoExecution.getMojoDescriptor(), project2, PluginExecutionException.constructMessage(mojoExecution, cause), (Throwable)cause);
        this.mojoExecution = mojoExecution;
    }

    public PluginExecutionException(MojoExecution mojoExecution, MavenProject project2, DuplicateArtifactAttachmentException cause) {
        super(mojoExecution.getMojoDescriptor(), project2, PluginExecutionException.constructMessage(mojoExecution, cause), (Throwable)cause);
        this.mojoExecution = mojoExecution;
    }

    public MojoExecution getMojoExecution() {
        return this.mojoExecution;
    }

    private static String constructMessage(MojoExecution mojoExecution, Throwable cause) {
        String message = mojoExecution != null ? "Execution " + mojoExecution.getExecutionId() + " of goal " + mojoExecution.getMojoDescriptor().getId() + " failed" : "Mojo execution failed";
        message = cause != null && StringUtils.isNotEmpty(cause.getMessage()) ? message + ": " + cause.getMessage() : message + ".";
        return message;
    }
}

