﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/securityhub/SecurityHub_EXPORTS.h>

namespace Aws {
namespace SecurityHub {
namespace Model {
enum class VulnerabilityExploitAvailable { NOT_SET, YES, NO };

namespace VulnerabilityExploitAvailableMapper {
AWS_SECURITYHUB_API VulnerabilityExploitAvailable GetVulnerabilityExploitAvailableForName(const Aws::String& name);

AWS_SECURITYHUB_API Aws::String GetNameForVulnerabilityExploitAvailable(VulnerabilityExploitAvailable value);
}  // namespace VulnerabilityExploitAvailableMapper
}  // namespace Model
}  // namespace SecurityHub
}  // namespace Aws
