/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.time.DateTimeException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.FoliationRepresentation;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.referencing.GeodeticObjectBuilder;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.internal.storage.csv.FeatureIterator;
import org.apache.sis.internal.storage.csv.Foliation;
import org.apache.sis.internal.storage.csv.MovingFeatureBuilder;
import org.apache.sis.internal.storage.csv.MovingFeatureIterator;
import org.apache.sis.internal.storage.csv.StoreProvider;
import org.apache.sis.internal.storage.csv.TimeEncoding;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.internal.storage.io.RewindableLineReader;
import org.apache.sis.internal.util.StandardDateFormat;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.io.InvalidSeekException;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.metadata.sql.MetadataStoreException;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataOptionKey;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;

final class Store
extends URIDataStore
implements FeatureSet {
    private static final char COMMENT = '#';
    static final char METADATA = '@';
    private static final char QUOTE = '\"';
    static final char SEPARATOR = ',';
    static final char ORDINATE_SEPARATOR = ' ';
    private static final String TYPE_PREFIX = "xsd:";
    private static final String XS_PREFIX = "xs:";
    private BufferedReader source;
    private final Charset encoding;
    private transient DefaultMetadata metadata;
    private final ImmutableEnvelope envelope;
    final DefaultFeatureType featureType;
    private boolean hasTrajectories;
    private short spatialDimensionCount;
    final Geometries<?> geometries;
    final Foliation foliation;
    private TimeEncoding timeEncoding;
    private boolean dissociate;
    private transient List<AbstractFeature> movingFeatures;

    public Store(StoreProvider storeProvider, StorageConnector storageConnector) throws DataStoreException {
        super(storeProvider, storageConnector);
        Reader reader = storageConnector.commit(Reader.class, "CSV");
        this.source = reader instanceof BufferedReader ? (BufferedReader)reader : new LineNumberReader(reader);
        this.geometries = Geometries.implementation(storageConnector.getOption(OptionKey.GEOMETRY_LIBRARY));
        this.dissociate = FoliationRepresentation.FRAGMENTED.equals((Object)storageConnector.getOption(DataOptionKey.FOLIATION_REPRESENTATION));
        GeneralEnvelope generalEnvelope = null;
        DefaultFeatureType defaultFeatureType = null;
        Foliation foliation = null;
        try {
            String string;
            ArrayList<String> arrayList = new ArrayList<String>();
            this.source.mark(8192);
            while ((string = this.source.readLine()) != null) {
                char c;
                if ((string = string.trim()).isEmpty() || (c = string.charAt(0)) == '#') continue;
                if (c != '@') break;
                Store.split(string, arrayList);
                String string2 = (String)arrayList.get(0);
                switch (string2.toLowerCase(Locale.US)) {
                    case "@stboundedby": {
                        if (generalEnvelope != null) {
                            throw new DataStoreContentException(this.duplicated("@stboundedby"));
                        }
                        if (defaultFeatureType != null) {
                            throw new DataStoreContentException(Resources.forLocale(this.getLocale()).getString((short)22, "@columns", "@stboundedby"));
                        }
                        generalEnvelope = this.parseEnvelope(arrayList);
                        this.dissociate |= this.timeEncoding == null;
                        break;
                    }
                    case "@columns": {
                        if (defaultFeatureType != null) {
                            throw new DataStoreContentException(this.duplicated("@columns"));
                        }
                        defaultFeatureType = this.parseFeatureType(arrayList);
                        break;
                    }
                    case "@foliation": {
                        if (foliation != null) {
                            throw new DataStoreContentException(this.duplicated("@foliation"));
                        }
                        foliation = this.parseFoliation(arrayList);
                        break;
                    }
                    default: {
                        LogRecord logRecord = this.errors().getLogRecord(Level.WARNING, (short)147, string2);
                        logRecord.setSourceClassName(Store.class.getName());
                        logRecord.setSourceMethodName("parseHeader");
                        this.listeners.warning(logRecord);
                        break;
                    }
                }
                arrayList.clear();
                this.source.mark(8192);
            }
            this.source.reset();
        }
        catch (IOException iOException) {
            throw new DataStoreException(this.getLocale(), "CSV", super.getDisplayName(), (Object)this.source).initCause(iOException);
        }
        catch (FactoryException factoryException) {
            throw new DataStoreReferencingException(this.getLocale(), "CSV", super.getDisplayName(), (Object)this.source).initCause(factoryException);
        }
        catch (IllegalArgumentException | DateTimeException runtimeException) {
            throw new DataStoreContentException(this.getLocale(), "CSV", super.getDisplayName(), (Object)this.source).initCause(runtimeException);
        }
        this.encoding = storageConnector.getOption(OptionKey.ENCODING);
        this.envelope = ImmutableEnvelope.castOrCopy(generalEnvelope);
        this.featureType = defaultFeatureType;
        this.foliation = foliation;
        this.dissociate |= this.timeEncoding == null;
        this.listeners.useWarningEventsOnly();
    }

    private void rewind() throws IOException {
        BufferedReader bufferedReader = this.source;
        if (!(bufferedReader instanceof RewindableLineReader)) {
            throw new InvalidSeekException(Resources.forLocale(this.getLocale()).getString((short)13, this.getDisplayName()));
        }
        this.source = ((RewindableLineReader)bufferedReader).rewind();
        if (this.source != bufferedReader) {
            char c;
            String string;
            while ((string = this.source.readLine()) != null && ((string = string.trim()).isEmpty() || (c = string.charAt(0)) == '#' || c == '@')) {
                this.source.mark(8192);
            }
            this.source.reset();
        }
    }

    private GeneralEnvelope parseEnvelope(List<String> list) throws DataStoreException, FactoryException {
        GeneralEnvelope generalEnvelope;
        int n;
        CoordinateReferenceSystem coordinateReferenceSystem = null;
        int n2 = 2;
        boolean bl = false;
        double[] dArray = ArraysExt.EMPTY_DOUBLE;
        double[] dArray2 = ArraysExt.EMPTY_DOUBLE;
        Instant instant = null;
        Instant instant2 = null;
        Unit<Time> unit = Units.SECOND;
        boolean bl2 = false;
        int n3 = -1;
        block25: for (String string : list) {
            ++n3;
            if (string.isEmpty()) continue;
            switch (n3) {
                case 0: {
                    continue block25;
                }
                case 1: {
                    coordinateReferenceSystem = CRS.forCode((String)string);
                    continue block25;
                }
                case 2: {
                    if (string.length() == 2 && Character.toUpperCase(string.charAt(1)) == 'D') {
                        bl = true;
                        n2 = string.charAt(0) - 48;
                        if (n2 >= 1 && n2 <= 3) continue block25;
                        throw new DataStoreReferencingException(this.errors().getString((short)51, string));
                    }
                    ++n3;
                }
                case 3: {
                    dArray = CharSequences.parseDoubles(string, ' ');
                    continue block25;
                }
                case 4: {
                    dArray2 = CharSequences.parseDoubles(string, ' ');
                    continue block25;
                }
                case 5: {
                    instant = StandardDateFormat.parseInstantUTC(string);
                    continue block25;
                }
                case 6: {
                    instant2 = StandardDateFormat.parseInstantUTC(string);
                    continue block25;
                }
                case 7: {
                    switch (string.toLowerCase(Locale.US)) {
                        case "sec": 
                        case "second": {
                            continue block25;
                        }
                        case "minute": {
                            unit = Units.MINUTE;
                            continue block25;
                        }
                        case "hour": {
                            unit = Units.HOUR;
                            continue block25;
                        }
                        case "day": {
                            unit = Units.DAY;
                            continue block25;
                        }
                        case "absolute": {
                            bl2 = true;
                            continue block25;
                        }
                    }
                    throw new DataStoreReferencingException(this.errors().getString((short)150, string));
                }
            }
            break;
        }
        if (coordinateReferenceSystem != null) {
            n = 0;
            Object object = new CoordinateReferenceSystem[3];
            object[n++] = coordinateReferenceSystem;
            int n4 = coordinateReferenceSystem.getCoordinateSystem().getDimension();
            if (bl) {
                if (n2 > n4) {
                    object[n++] = CommonCRS.Vertical.MEAN_SEA_LEVEL.crs();
                    ++n4;
                }
                if (n4 != n2) {
                    throw new DataStoreReferencingException(this.errors().getString((short)81, "@stboundedby(CRS)", n2, n4));
                }
            }
            if (n4 >= Short.MAX_VALUE) {
                throw new DataStoreReferencingException(this.errors().getString((short)37, n4));
            }
            n2 = n4;
            GeodeticObjectBuilder geodeticObjectBuilder = new GeodeticObjectBuilder();
            String string = coordinateReferenceSystem.getName().getCode();
            if (instant != null) {
                TemporalCRS temporalCRS;
                if (bl2) {
                    temporalCRS = TimeEncoding.DEFAULT.crs();
                    this.timeEncoding = TimeEncoding.ABSOLUTE;
                } else {
                    temporalCRS = geodeticObjectBuilder.createTemporalCRS(Date.from(instant), unit);
                    this.timeEncoding = new TimeEncoding(temporalCRS.getDatum(), unit);
                }
                object[n++] = temporalCRS;
                string = string + " + " + temporalCRS.getName().getCode();
            }
            coordinateReferenceSystem = ((GeodeticObjectBuilder)geodeticObjectBuilder.addName((CharSequence)string)).createCompoundCRS((CoordinateReferenceSystem[])ArraysExt.resize(object, n));
            generalEnvelope = new GeneralEnvelope(coordinateReferenceSystem);
        } else {
            n = n2;
            if (instant != null) {
                ++n;
            }
            generalEnvelope = new GeneralEnvelope(n);
        }
        n = dArray.length;
        if (n != n2 || (n = dArray2.length) != n2) {
            throw new DataStoreReferencingException(this.errors().getString((short)81, "@stboundedby(BBOX)", n2, n));
        }
        for (int i = 0; i < n2; ++i) {
            generalEnvelope.setRange(i, dArray[i], dArray2[i]);
        }
        if (instant != null) {
            generalEnvelope.setRange(n2, this.timeEncoding.toCRS(instant.toEpochMilli()), instant2 == null ? Double.NaN : this.timeEncoding.toCRS(instant2.toEpochMilli()));
        }
        this.spatialDimensionCount = (short)n2;
        return generalEnvelope;
    }

    private DefaultFeatureType parseFeatureType(List<String> list) throws DataStoreException {
        DefaultAttributeType[] defaultAttributeTypeArray = null;
        int n = list.size();
        ArrayList<AbstractIdentifiedType> arrayList = new ArrayList<AbstractIdentifiedType>();
        for (int i = 1; i < n; ++i) {
            int n2;
            String string;
            String string2 = list.get(i);
            Class clazz = null;
            if (++i < n && ((string = list.get(i)).regionMatches(true, 0, TYPE_PREFIX, 0, n2 = TYPE_PREFIX.length()) || string.regionMatches(true, 0, XS_PREFIX, 0, n2 = XS_PREFIX.length()))) {
                String string3;
                switch (string3 = string.substring(n2).toLowerCase(Locale.US)) {
                    case "boolean": {
                        clazz = Boolean.class;
                        break;
                    }
                    case "decimal": {
                        clazz = Double.class;
                        break;
                    }
                    case "integer": {
                        clazz = Integer.class;
                        break;
                    }
                    case "string": {
                        clazz = String.class;
                        break;
                    }
                    case "datetime": {
                        clazz = Instant.class;
                        break;
                    }
                    case "anyuri": {
                        clazz = URI.class;
                        break;
                    }
                    default: {
                        throw new DataStoreContentException(this.errors().getString((short)149, string));
                    }
                }
            }
            int n3 = 0;
            int n4 = n2 = this.dissociate ? 1 : Integer.MAX_VALUE;
            if (clazz == null) {
                clazz = String.class;
                switch (--i) {
                    case 0: 
                    case 1: {
                        n3 = 1;
                        n2 = 1;
                        break;
                    }
                    case 2: {
                        if (!string2.equalsIgnoreCase("trajectory")) break;
                        this.hasTrajectories = true;
                        if (this.timeEncoding != null) {
                            arrayList.add(Store.createProperty("startTime", Instant.class, 1, 1, null));
                            arrayList.add(Store.createProperty("endTime", Instant.class, 1, 1, null));
                        }
                        if (this.dissociate) {
                            clazz = double[].class;
                        } else {
                            clazz = this.geometries.polylineClass;
                            defaultAttributeTypeArray = new DefaultAttributeType[]{MovingFeatureBuilder.TIME_AS_INSTANTS};
                        }
                        n3 = 1;
                        n2 = 1;
                    }
                }
            }
            arrayList.add(Store.createProperty(string2, clazz, n3, n2, defaultAttributeTypeArray));
        }
        String string = IOUtilities.filenameWithoutExtension(super.getDisplayName());
        return new DefaultFeatureType(Collections.singletonMap("name", string), false, null, arrayList.toArray(new AbstractIdentifiedType[arrayList.size()]));
    }

    private static AbstractIdentifiedType createProperty(String string, Class<?> clazz, int n, int n2, DefaultAttributeType<?>[] defaultAttributeTypeArray) {
        return new DefaultAttributeType<Object>(Collections.singletonMap("name", string), clazz, n, n2, null, defaultAttributeTypeArray);
    }

    private Foliation parseFoliation(List<String> list) {
        if (list.size() >= 2) {
            return Foliation.valueOf(list.get(1).toUpperCase(Locale.US));
        }
        return Foliation.TIME;
    }

    @Override
    public Optional<GenericName> getIdentifier() throws DataStoreException {
        return Optional.of(this.featureType.getName());
    }

    @Override
    public synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            MetadataBuilder metadataBuilder = new MetadataBuilder();
            String string = this.timeEncoding != null && this.hasTrajectories ? "CSV-MF" : "CSV";
            try {
                metadataBuilder.setPredefinedFormat(string);
            }
            catch (MetadataStoreException metadataStoreException) {
                metadataBuilder.addFormatName(string);
                this.listeners.warning((Exception)((Object)metadataStoreException));
            }
            metadataBuilder.addEncoding(this.encoding, MetadataBuilder.Scope.ALL);
            metadataBuilder.addResourceScope(ScopeCode.DATASET, null);
            try {
                metadataBuilder.addExtent((Envelope)this.envelope);
            }
            catch (TransformException transformException) {
                throw new DataStoreReferencingException(this.getLocale(), "CSV", this.getDisplayName(), (Object)this.source).initCause(transformException);
            }
            metadataBuilder.addFeatureType(this.featureType, -1L);
            this.addTitleOrIdentifier(metadataBuilder);
            metadataBuilder.setISOStandards(false);
            this.metadata = metadataBuilder.buildAndFreeze();
        }
        return this.metadata;
    }

    @Override
    public Optional<Envelope> getEnvelope() throws DataStoreException {
        return Optional.ofNullable(this.envelope);
    }

    @Override
    public DefaultFeatureType getType() {
        return this.featureType;
    }

    @Override
    public final synchronized Stream<AbstractFeature> features(boolean bl) throws DataStoreException {
        if (this.dissociate) {
            return StreamSupport.stream(new FeatureIterator(this), bl);
        }
        if (this.movingFeatures == null) {
            try {
                MovingFeatureIterator movingFeatureIterator = new MovingFeatureIterator(this);
                movingFeatureIterator.readMoving(null, true);
                this.movingFeatures = UnmodifiableArrayList.wrap(movingFeatureIterator.createMovingFeatures());
            }
            catch (IOException | IllegalArgumentException | DateTimeException exception) {
                throw new DataStoreException(this.canNotParseFile(), exception);
            }
        }
        return this.movingFeatures.stream();
    }

    static void split(String string, List<? super String> list) {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = string.length();
        block4: for (int i = 0; i < n2; ++i) {
            switch (string.charAt(i)) {
                case '\"': {
                    bl2 = true;
                    if (bl && i + 1 < n2 && string.charAt(i + 1) == '\"') {
                        ++i;
                        continue block4;
                    }
                    bl = !bl;
                    continue block4;
                }
                case ',': {
                    if (bl) continue block4;
                    if (!list.add(Store.decode(string, n, i, bl2))) {
                        return;
                    }
                    n = i + 1;
                    bl2 = false;
                }
            }
        }
        list.add(Store.decode(string, n, n2, bl2));
    }

    private static String decode(CharSequence charSequence, int n, int n2, boolean bl) {
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder(n2 - n).append(charSequence, n, n2);
            for (int i = 0; i < stringBuilder.length(); ++i) {
                if (stringBuilder.charAt(i) != '\"') continue;
                stringBuilder.deleteCharAt(i);
            }
            charSequence = CharSequences.trimWhitespaces(stringBuilder);
        } else {
            charSequence = CharSequences.trimWhitespaces(charSequence, n, n2);
        }
        return charSequence.toString();
    }

    final boolean hasTrajectories() {
        return this.hasTrajectories;
    }

    final int spatialDimensionCount() {
        return this.spatialDimensionCount;
    }

    final TimeEncoding timeEncoding() {
        return this.timeEncoding;
    }

    final String readLine() throws IOException {
        return this.source.readLine();
    }

    private String duplicated(String string) {
        return this.errors().getString((short)24, string);
    }

    final String canNotParseFile() {
        return IOUtilities.canNotReadFile(this.getLocale(), "CSV", this.getDisplayName(), this.source);
    }

    private Errors errors() {
        return Errors.getResources(this.getLocale());
    }

    final void log(LogRecord logRecord) {
        logRecord.setSourceClassName(Store.class.getName());
        logRecord.setSourceMethodName("features");
        this.listeners.warning(logRecord);
    }

    @Override
    public synchronized void close() throws DataStoreException {
        BufferedReader bufferedReader = this.source;
        this.source = null;
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                throw new DataStoreException(iOException);
            }
        }
    }
}

