#if !defined(TORCH_STABLE_ONLY) && !defined(TORCH_TARGET_VERSION)
#pragma once

// @generated by torchgen/gen.py from Function.h

#include <ATen/Context.h>
#include <ATen/DeviceGuard.h>
#include <ATen/TensorUtils.h>
#include <ATen/TracerMode.h>
#include <ATen/core/Generator.h>
#include <ATen/core/Reduction.h>
#include <ATen/core/Tensor.h>
#include <c10/core/Scalar.h>
#include <c10/core/Storage.h>
#include <c10/core/TensorOptions.h>
#include <c10/util/Deprecated.h>
#include <optional>
#include <string_view>



#include <ATen/ops/triu_ops.h>

namespace at {


namespace symint {
  template <typename T, typename = std::enable_if_t<std::is_same_v<T, int64_t>>>
  at::Tensor & triu_(at::Tensor & self, int64_t diagonal=0) {
    return at::_ops::triu_::call(self, diagonal);
  }
}

namespace symint {
  template <typename T, typename = std::enable_if_t<std::is_same_v<T, c10::SymInt>>>
  at::Tensor & triu_(at::Tensor & self, c10::SymInt diagonal=0) {
    return at::_ops::triu_::call(self, diagonal);
  }
}

// aten::triu.out(Tensor self, SymInt diagonal=0, *, Tensor(a!) out) -> Tensor(a!)
inline at::Tensor & triu_out(at::Tensor & out, const at::Tensor & self, int64_t diagonal=0) {
    return at::_ops::triu_out::call(self, diagonal, out);
}
namespace symint {
  template <typename T, typename = std::enable_if_t<std::is_same_v<T, int64_t>>>
  at::Tensor & triu_out(at::Tensor & out, const at::Tensor & self, int64_t diagonal=0) {
    return at::_ops::triu_out::call(self, diagonal, out);
  }
}

// aten::triu.out(Tensor self, SymInt diagonal=0, *, Tensor(a!) out) -> Tensor(a!)
inline at::Tensor & triu_outf(const at::Tensor & self, int64_t diagonal, at::Tensor & out) {
    return at::_ops::triu_out::call(self, diagonal, out);
}
namespace symint {
  template <typename T, typename = std::enable_if_t<std::is_same_v<T, int64_t>>>
  at::Tensor & triu_outf(const at::Tensor & self, int64_t diagonal, at::Tensor & out) {
    return at::_ops::triu_out::call(self, diagonal, out);
  }
}

// aten::triu.out(Tensor self, SymInt diagonal=0, *, Tensor(a!) out) -> Tensor(a!)
inline at::Tensor & triu_symint_out(at::Tensor & out, const at::Tensor & self, c10::SymInt diagonal=0) {
    return at::_ops::triu_out::call(self, diagonal, out);
}
namespace symint {
  template <typename T, typename = std::enable_if_t<std::is_same_v<T, c10::SymInt>>>
  at::Tensor & triu_out(at::Tensor & out, const at::Tensor & self, c10::SymInt diagonal=0) {
    return at::_ops::triu_out::call(self, diagonal, out);
  }
}

// aten::triu.out(Tensor self, SymInt diagonal=0, *, Tensor(a!) out) -> Tensor(a!)
inline at::Tensor & triu_symint_outf(const at::Tensor & self, c10::SymInt diagonal, at::Tensor & out) {
    return at::_ops::triu_out::call(self, diagonal, out);
}
namespace symint {
  template <typename T, typename = std::enable_if_t<std::is_same_v<T, c10::SymInt>>>
  at::Tensor & triu_outf(const at::Tensor & self, c10::SymInt diagonal, at::Tensor & out) {
    return at::_ops::triu_out::call(self, diagonal, out);
  }
}

// aten::triu(Tensor self, SymInt diagonal=0) -> Tensor
inline at::Tensor triu(const at::Tensor & self, int64_t diagonal=0) {
    return at::_ops::triu::call(self, diagonal);
}
namespace symint {
  template <typename T, typename = std::enable_if_t<std::is_same_v<T, int64_t>>>
  at::Tensor triu(const at::Tensor & self, int64_t diagonal=0) {
    return at::_ops::triu::call(self, diagonal);
  }
}

// aten::triu(Tensor self, SymInt diagonal=0) -> Tensor
inline at::Tensor triu_symint(const at::Tensor & self, c10::SymInt diagonal=0) {
    return at::_ops::triu::call(self, diagonal);
}
namespace symint {
  template <typename T, typename = std::enable_if_t<std::is_same_v<T, c10::SymInt>>>
  at::Tensor triu(const at::Tensor & self, c10::SymInt diagonal=0) {
    return at::_ops::triu::call(self, diagonal);
  }
}

}

#else
#error "This file should not be included when either TORCH_STABLE_ONLY or TORCH_TARGET_VERSION is defined."
#endif  // !defined(TORCH_STABLE_ONLY) && !defined(TORCH_TARGET_VERSION)
