/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.transform;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import org.tribuo.Dataset;
import org.tribuo.Model;
import org.tribuo.MutableDataset;
import org.tribuo.Output;
import org.tribuo.Trainer;
import org.tribuo.provenance.DatasetProvenance;
import org.tribuo.provenance.ModelProvenance;
import org.tribuo.provenance.TrainerProvenance;
import org.tribuo.provenance.impl.TrainerProvenanceImpl;
import org.tribuo.transform.TransformationMap;
import org.tribuo.transform.TransformedModel;
import org.tribuo.transform.TransformerMap;

public final class TransformTrainer<T extends Output<T>>
implements Trainer<T> {
    private static final Logger logger = Logger.getLogger(TransformTrainer.class.getName());
    @Config(mandatory=true, description="Trainer to use.")
    private Trainer<T> innerTrainer;
    @Config(mandatory=true, description="Transformations to apply.")
    private TransformationMap transformations;
    @Config(description="Densify all the features before applying transformations.")
    private boolean densify;
    @Config(description="Include the implicit zeros in the transformation statistics collection")
    private boolean includeImplicitZeroFeatures;

    private TransformTrainer() {
    }

    public TransformTrainer(Trainer<T> innerTrainer, TransformationMap transformations) {
        this(innerTrainer, transformations, false);
    }

    public TransformTrainer(Trainer<T> innerTrainer, TransformationMap transformations, boolean densify) {
        this(innerTrainer, transformations, densify, false);
    }

    public TransformTrainer(Trainer<T> innerTrainer, TransformationMap transformations, boolean densify, boolean includeImplicitZeroFeatures) {
        this.innerTrainer = innerTrainer;
        this.transformations = transformations;
        this.densify = densify;
        this.includeImplicitZeroFeatures = includeImplicitZeroFeatures;
    }

    @Override
    public TransformedModel<T> train(Dataset<T> examples, Map<String, Provenance> instanceProvenance) {
        return this.train((Dataset)examples, (Map)instanceProvenance, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransformedModel<T> train(Dataset<T> examples, Map<String, Provenance> instanceProvenance, int invocationCount) {
        Model<T> innerModel;
        TrainerProvenance provenance;
        logger.fine("Creating transformers");
        TransformerMap transformerMap = examples.createTransformers(this.transformations, this.includeImplicitZeroFeatures);
        logger.fine("Transforming data set");
        MutableDataset<T> transformedDataset = transformerMap.transformDataset(examples, this.densify);
        logger.fine("Running inner trainer");
        Trainer<T> trainer = this.innerTrainer;
        synchronized (trainer) {
            provenance = this.getProvenance();
            innerModel = this.innerTrainer.train(transformedDataset, Collections.emptyMap(), invocationCount);
        }
        ModelProvenance modelProvenance = new ModelProvenance(TransformedModel.class.getName(), OffsetDateTime.now(), (DatasetProvenance)transformedDataset.getProvenance(), provenance, instanceProvenance);
        return new TransformedModel<T>(modelProvenance, innerModel, transformerMap, this.densify);
    }

    @Override
    public int getInvocationCount() {
        return this.innerTrainer.getInvocationCount();
    }

    @Override
    public synchronized void setInvocationCount(int invocationCount) {
        this.innerTrainer.setInvocationCount(invocationCount);
    }

    public TrainerProvenance getProvenance() {
        return new TrainerProvenanceImpl(this);
    }
}

