/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.decoration;

import javafx.collections.ObservableList;
import javafx.scene.Node;
import org.controlsfx.control.decoration.Decoration;

public class StyleClassDecoration
extends Decoration {
    private final String[] styleClasses;

    public StyleClassDecoration(String ... styleClass) {
        if (styleClass == null || styleClass.length == 0) {
            throw new IllegalArgumentException("var-arg style class array must not be null or empty");
        }
        this.styleClasses = styleClass;
    }

    @Override
    public Node applyDecoration(Node targetNode) {
        ObservableList<String> styleClassList = targetNode.getStyleClass();
        for (String styleClass : this.styleClasses) {
            if (styleClassList.contains(styleClass)) continue;
            styleClassList.add(styleClass);
        }
        return null;
    }

    @Override
    public void removeDecoration(Node targetNode) {
        targetNode.getStyleClass().removeAll((String[])this.styleClasses);
    }
}

