/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.headers.SecurityHeadersProvider;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.SingleUseObjectProvider;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.TokenRevokeContext;
import org.keycloak.services.clientpolicy.context.TokenRevokeResponseContext;
import org.keycloak.services.cors.Cors;
import org.keycloak.services.managers.UserSessionManager;
import org.keycloak.services.util.UserSessionUtil;

public class TokenRevocationEndpoint {
    public static final String PARAM_TOKEN = "token";
    private final KeycloakSession session;
    private final HttpRequest request;
    private final ClientConnection clientConnection;
    private MultivaluedMap<String, String> formParams;
    private ClientModel client;
    private final RealmModel realm;
    private final EventBuilder event;
    private Cors cors;
    private AccessToken token;
    private UserModel user;

    public TokenRevocationEndpoint(KeycloakSession session, EventBuilder event) {
        this.session = session;
        this.clientConnection = session.getContext().getConnection();
        this.realm = session.getContext().getRealm();
        this.event = event;
        this.request = session.getContext().getHttpRequest();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response revoke() {
        this.event.event(EventType.REVOKE_GRANT);
        this.cors = Cors.builder().auth().allowedMethods(new String[]{"POST"}).auth().exposedHeaders(new String[]{"Access-Control-Allow-Methods"});
        this.checkSsl();
        this.checkRealm();
        this.checkClient();
        this.formParams = this.request.getDecodedFormParameters();
        this.checkParameterDuplicated(this.formParams);
        try {
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new TokenRevokeContext(this.formParams));
        }
        catch (ClientPolicyException cpe) {
            this.event.detail("reason", "client_policy_error");
            this.event.detail("client_policy_error", cpe.getError());
            this.event.detail("client_policy_error_detail", cpe.getErrorDetail());
            this.event.error(cpe.getError());
            throw new CorsErrorResponseException(this.cors, cpe.getError(), cpe.getErrorDetail(), cpe.getErrorStatus());
        }
        this.checkToken();
        this.checkIssuedFor();
        this.checkUser();
        if ("Refresh".equals(this.token.getType()) || "Offline".equals(this.token.getType())) {
            this.revokeClientSession();
            this.event.detail("revoked_client", this.client.getClientId());
            this.event.session(this.token.getSessionId());
            this.event.detail("refresh_token_id", this.token.getId());
            this.event.detail("refresh_token_type", this.token.getType());
        } else {
            this.revokeAccessToken();
            this.event.detail("token_id", this.token.getId());
        }
        this.event.success();
        try {
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new TokenRevokeResponseContext(this.formParams));
        }
        catch (ClientPolicyException cpe) {
            this.event.detail("reason", "client_policy_error");
            this.event.detail("client_policy_error", cpe.getError());
            this.event.detail("client_policy_error_detail", cpe.getErrorDetail());
            this.event.error(cpe.getError());
            throw new CorsErrorResponseException(this.cors, cpe.getError(), cpe.getErrorDetail(), cpe.getErrorStatus());
        }
        ((SecurityHeadersProvider)this.session.getProvider(SecurityHeadersProvider.class)).options().allowEmptyContentType();
        return this.cors.add(Response.ok());
    }

    @OPTIONS
    public Response preflight() {
        return Cors.builder().auth().preflight().allowedMethods(new String[]{"POST", "OPTIONS"}).add(Response.ok());
    }

    private void checkSsl() {
        if (!this.session.getContext().getUri().getBaseUri().getScheme().equals("https") && this.realm.getSslRequired().isRequired(this.clientConnection)) {
            throw new CorsErrorResponseException(this.cors.allowAllOrigins(), "invalid_request", "HTTPS required", Response.Status.FORBIDDEN);
        }
    }

    private void checkRealm() {
        if (!this.realm.isEnabled()) {
            throw new CorsErrorResponseException(this.cors.allowAllOrigins(), "access_denied", "Realm not enabled", Response.Status.FORBIDDEN);
        }
    }

    private void checkClient() {
        AuthorizeClientUtil.ClientAuthResult clientAuth = AuthorizeClientUtil.authorizeClient(this.session, this.event, this.cors);
        this.client = clientAuth.getClient();
        this.event.client(this.client);
        this.cors.allowedOrigins(this.session, this.client);
        if (this.client.isBearerOnly()) {
            throw new CorsErrorResponseException(this.cors, "invalid_client", "Bearer-only not allowed", Response.Status.BAD_REQUEST);
        }
    }

    private void checkToken() {
        String encodedToken = (String)this.formParams.getFirst((Object)PARAM_TOKEN);
        if (encodedToken == null) {
            this.event.detail("reason", "Token not provided");
            this.event.error("invalid_request");
            throw new CorsErrorResponseException(this.cors, "invalid_request", "Token not provided", Response.Status.BAD_REQUEST);
        }
        this.token = (AccessToken)this.session.tokens().decode(encodedToken, AccessToken.class);
        if (this.token == null) {
            this.event.error("invalid_token");
            throw new CorsErrorResponseException(this.cors, "invalid_token", "Invalid token", Response.Status.OK);
        }
        if (!("Refresh".equals(this.token.getType()) || "Offline".equals(this.token.getType()) || "Bearer".equals(this.token.getType()) || "DPoP".equals(this.token.getType()))) {
            this.event.detail("reason", "Unsupported token type");
            this.event.error("invalid_token_type");
            throw new CorsErrorResponseException(this.cors, "unsupported_token_type", "Unsupported token type", Response.Status.BAD_REQUEST);
        }
    }

    private void checkIssuedFor() {
        String issuedFor = this.token.getIssuedFor();
        if (issuedFor == null) {
            this.event.detail("reason", "Issued for not set");
            this.event.error("invalid_token");
            throw new CorsErrorResponseException(this.cors, "invalid_token", "Invalid token", Response.Status.OK);
        }
        if (!this.client.getClientId().equals(issuedFor)) {
            this.event.detail("reason", "Unmatching clients");
            this.event.error("invalid_request");
            throw new CorsErrorResponseException(this.cors, "invalid_request", "Unmatching clients", Response.Status.BAD_REQUEST);
        }
    }

    private void checkUser() {
        UserSessionUtil.UserSessionValidationResult validationResult = UserSessionUtil.findValidSessionForAccessToken(this.session, this.realm, this.token, this.client, t -> {});
        if (validationResult.getError() != null) {
            this.event.error(validationResult.getError());
            throw new CorsErrorResponseException(this.cors, "invalid_token", "Invalid token", Response.Status.OK);
        }
        this.user = validationResult.getUserSession().getUser();
        if (this.user == null) {
            this.event.error("user_not_found");
            throw new CorsErrorResponseException(this.cors, "invalid_token", "Invalid token", Response.Status.OK);
        }
        this.event.user(this.user);
    }

    private void checkParameterDuplicated(MultivaluedMap<String, String> formParams) {
        for (List strings : formParams.values()) {
            if (strings.size() == 1) continue;
            throw new CorsErrorResponseException(this.cors, "invalid_request", "duplicated parameter", Response.Status.BAD_REQUEST);
        }
    }

    private void revokeClientSession() {
        AuthenticatedClientSessionModel clientSession;
        UserSessionModel userSession;
        if ("Offline".equals(this.token.getType()) && (userSession = this.session.sessions().getOfflineUserSession(this.realm, this.token.getSessionId())) != null) {
            new UserSessionManager(this.session).removeClientFromOfflineUserSession(this.realm, userSession, this.client, this.user);
        }
        if ((userSession = this.session.sessions().getUserSession(this.realm, this.token.getSessionId())) != null && (clientSession = userSession.getAuthenticatedClientSessionByClient(this.client.getId())) != null) {
            TokenManager.dettachClientSession(clientSession);
            this.revokeTokenExchangeSession(userSession);
            if (userSession.getAuthenticatedClientSessions().isEmpty()) {
                this.session.sessions().removeUserSession(this.realm, userSession);
            }
        }
    }

    private void revokeAccessToken() {
        SingleUseObjectProvider singleUseStore = this.session.singleUseObjects();
        int currentTime = Time.currentTime();
        long lifespanInSecs = Math.max(this.token.getExp() - (long)currentTime + 1L, 10L);
        singleUseStore.put(this.token.getId() + ".revoked", lifespanInSecs, Collections.emptyMap());
        this.revokeTokenExchangeSession();
    }

    private void revokeTokenExchangeSession() {
        UserSessionModel userSession;
        if (this.token.getSessionId() != null && (userSession = this.session.sessions().getUserSession(this.realm, this.token.getSessionId())) != null) {
            this.revokeTokenExchangeSession(userSession);
        }
    }

    private void revokeTokenExchangeSession(UserSessionModel userSession) {
        Map clientSessionModelMap = userSession.getAuthenticatedClientSessions();
        ArrayList revokedClients = new ArrayList();
        clientSessionModelMap.forEach((key, clientSessionModel) -> {
            if (clientSessionModel.getNote("token_exchange_subject_client" + this.token.getIssuedFor()) != null) {
                revokedClients.add(clientSessionModel.getClient().getClientId());
                TokenManager.dettachClientSession(clientSessionModel);
            }
        });
        if (!revokedClients.isEmpty()) {
            this.event.detail("token_exchange_revoked_clients", String.join((CharSequence)",", revokedClients));
        }
    }
}

