/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.entities;

import java.util.HashSet;
import java.util.Set;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.cache.infinispan.entities.AbstractRevisioned;
import org.keycloak.models.cache.infinispan.entities.InIdentityProvider;
import org.keycloak.models.cache.infinispan.entities.InRealm;

public class CachedFederatedIdentityLinks
extends AbstractRevisioned
implements InRealm,
InIdentityProvider {
    private final String realmId;
    private final Set<FederatedIdentityModel> federatedIdentities = new HashSet<FederatedIdentityModel>();

    public CachedFederatedIdentityLinks(Long revision, String id, RealmModel realm, Set<FederatedIdentityModel> federatedIdentities) {
        super(revision, id);
        this.realmId = realm.getId();
        this.federatedIdentities.addAll(federatedIdentities);
    }

    @Override
    public String getRealm() {
        return this.realmId;
    }

    public Set<FederatedIdentityModel> getFederatedIdentities() {
        return this.federatedIdentities;
    }

    @Override
    public boolean contains(String alias) {
        return this.federatedIdentities.stream().anyMatch(federatedIdentityModel -> federatedIdentityModel.getIdentityProvider().equals(alias));
    }
}

