/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.Transaction;
import org.hibernate.TransactionManagementException;

public class TransactionManagement {
    public static <S> void manageTransaction(S session, Transaction transaction, Consumer<S> consumer) {
        try {
            consumer.accept(session);
            TransactionManagement.commit(transaction);
        }
        catch (RuntimeException exception) {
            TransactionManagement.rollback(transaction, exception);
            throw exception;
        }
    }

    public static <S, R> R manageTransaction(S session, Transaction transaction, Function<S, R> function) {
        try {
            R result = function.apply(session);
            TransactionManagement.commit(transaction);
            return result;
        }
        catch (RuntimeException exception) {
            TransactionManagement.rollback(transaction, exception);
            throw exception;
        }
    }

    private static void rollback(Transaction transaction, RuntimeException exception) {
        if (transaction.isActive()) {
            try {
                transaction.rollback();
            }
            catch (RuntimeException e) {
                exception.addSuppressed(e);
            }
        }
    }

    private static void commit(Transaction transaction) {
        if (!transaction.isActive()) {
            throw new TransactionManagementException("Execution of action caused managed transaction to be completed");
        }
        transaction.commit();
    }
}

