﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/fis/FISRequest.h>
#include <aws/fis/FIS_EXPORTS.h>

#include <utility>

namespace Aws {
namespace FIS {
namespace Model {

/**
 */
class DeleteTargetAccountConfigurationRequest : public FISRequest {
 public:
  AWS_FIS_API DeleteTargetAccountConfigurationRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteTargetAccountConfiguration"; }

  AWS_FIS_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The ID of the experiment template.</p>
   */
  inline const Aws::String& GetExperimentTemplateId() const { return m_experimentTemplateId; }
  inline bool ExperimentTemplateIdHasBeenSet() const { return m_experimentTemplateIdHasBeenSet; }
  template <typename ExperimentTemplateIdT = Aws::String>
  void SetExperimentTemplateId(ExperimentTemplateIdT&& value) {
    m_experimentTemplateIdHasBeenSet = true;
    m_experimentTemplateId = std::forward<ExperimentTemplateIdT>(value);
  }
  template <typename ExperimentTemplateIdT = Aws::String>
  DeleteTargetAccountConfigurationRequest& WithExperimentTemplateId(ExperimentTemplateIdT&& value) {
    SetExperimentTemplateId(std::forward<ExperimentTemplateIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Web Services account ID of the target account.</p>
   */
  inline const Aws::String& GetAccountId() const { return m_accountId; }
  inline bool AccountIdHasBeenSet() const { return m_accountIdHasBeenSet; }
  template <typename AccountIdT = Aws::String>
  void SetAccountId(AccountIdT&& value) {
    m_accountIdHasBeenSet = true;
    m_accountId = std::forward<AccountIdT>(value);
  }
  template <typename AccountIdT = Aws::String>
  DeleteTargetAccountConfigurationRequest& WithAccountId(AccountIdT&& value) {
    SetAccountId(std::forward<AccountIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_experimentTemplateId;

  Aws::String m_accountId;
  bool m_experimentTemplateIdHasBeenSet = false;
  bool m_accountIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace FIS
}  // namespace Aws
